﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../settings/settingsmenu.xsl"/>
  <xsl:output indent="yes" method="html"/>
  
  <xsl:template name="timerListControls">
    <div class="timer-controls">
      <div class="CSSButton158 left timerControlTransition" style="opacity:1" id="edit">{{timerTemplatesListControlButtonEdit}}</div>
      <div class="deleteButton inactive left timerControlTransition" style="opacity:0" id="delete">{{timerTemplatesListControlButtonDelete}}</div>
      <div class="add-timer cssButtonRtc">
        <div class="sprites {{{{gc4_icon_config_plus}}}}"></div>
      </div>
      <div class="CSSButton158 right" id="ok">{{timerTemplatesListControlButtonOk}}</div>
    </div>
    <div class="white-timer-divider"></div>
  </xsl:template>

  <xsl:template name="timerEditControls">
    <div class="timer-controls">
      <div class="CSSButton158 left" id="cancel">{{timerTemplatesEditControlButtonCancel}}</div>
      <div class="CSSButton158 right" id="ok">{{timerTemplatesListControlButtonOk}}</div>
    </div>
    <div class="white-timer-divider"></div>
  </xsl:template>

  <xsl:template name="rtcTimerAction">
    <div id="rtcTimerAction">
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesRtcTimerActionKomfort}}</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesRtcTimerActionStandby}}</xsl:with-param>
        <xsl:with-param name="value">2</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesRtcTimerActionNight}}</xsl:with-param>
        <xsl:with-param name="value">3</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesRtcTimerActionFrost}}</xsl:with-param>
        <xsl:with-param name="value">4</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

  <xsl:template name="switchTimerAction">
    <div id="switchTimerAction">
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesSwitchTimerActionOn}}</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesSwitchTimerActionOff}}</xsl:with-param>
        <xsl:with-param name="value">2</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

  <xsl:template name="dimmerTimerAction">
    <div id="dimmerTimerAction">
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">0 %</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">10 %</xsl:with-param>
        <xsl:with-param name="value">2</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">20 %</xsl:with-param>
        <xsl:with-param name="value">3</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">30 %</xsl:with-param>
        <xsl:with-param name="value">4</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">40 %</xsl:with-param>
        <xsl:with-param name="value">5</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">50 %</xsl:with-param>
        <xsl:with-param name="value">6</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">60 %</xsl:with-param>
        <xsl:with-param name="value">7</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">70 %</xsl:with-param>
        <xsl:with-param name="value">8</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">80 %</xsl:with-param>
        <xsl:with-param name="value">9</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">90 %</xsl:with-param>
        <xsl:with-param name="value">10</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">100 %</xsl:with-param>
        <xsl:with-param name="value">11</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

  <xsl:template name="sceneTimerAction">
    <div id="sceneTimerAction">
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">{{timerTemplatesSceneTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

  <xsl:template name="blindShutterTimerAction">
    <div id="blindShutterTimerAction">
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">0 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">1</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">10 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">2</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">20 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">3</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">30 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">4</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">40 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">5</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">50 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">6</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">60 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">7</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">70 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">8</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">80 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">9</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">90 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">10</xsl:with-param>
      </xsl:call-template>
      <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
      <xsl:call-template name="timerActionRow">
        <xsl:with-param name="text">100 % {{timerTemplatesBlindShutterTimerActionRowText}}</xsl:with-param>
        <xsl:with-param name="value">11</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

  <xsl:template name="timerActionRow">
    <xsl:param name="text"/>
    <xsl:param name="value"/>
    <div class="timer-action-row t2sg">
      <div class="flow-top"></div>
      <span>
        <xsl:value-of select="$text"/>
      </span>
      <xsl:call-template name="radioButtonElement">
        <xsl:with-param name="id" select="$value"/>
        <xsl:with-param name="name">timerAction</xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>

    <xsl:template name="shutterRelativeTimerAction">
        <div id="shutterRelativeTimerAction">
            <xsl:call-template name="timerActionRow">
                <xsl:with-param name="text">{{timerTemplatesShutterRelativeTimerActionTo}}</xsl:with-param>
                <xsl:with-param name="value">1</xsl:with-param>
            </xsl:call-template>
            <div class="timer-action-gridline {{{{tile-grid-line}}}}"></div>
            <xsl:call-template name="timerActionRow">
                <xsl:with-param name="text">{{timerTemplatesShutterRelativeTimerActionFrom}}</xsl:with-param>
                <xsl:with-param name="value">2</xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>

</xsl:stylesheet>
