﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-switch-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch' and @Name='OnOff']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch' and @Name='OnOffStatus']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-brightness-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='BrightnessStatus']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-led-on">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@On" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-led-off">
        <xsl:text>{{statusled-</xsl:text>
        <xsl:value-of select="Channel/StatusLed/@Off" />
        <xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-channel-index">
        <xsl:value-of select="Channel/@Index"/>
      </xsl:attribute>
      <xsl:attribute name="data-container-index">
        <xsl:value-of select="Channel/@ContainerIndex"/>
      </xsl:attribute>
      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <xsl:if test="Channel/StatusValue/@Enable = 'true'">
            <div class="tile-status-text t2gg">- %</div>
          </xsl:if>
        </xsl:with-param>
        <xsl:with-param name="controlElements">
          <xsl:call-template name="toggleSwitchButton">
            <xsl:with-param name="Id">
              <xsl:text>onoffswitch-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" />
            </xsl:with-param>
            <xsl:with-param name="ColorIdLeft" select="Channel/StatusLed/@On" />
            <xsl:with-param name="ColorIdRight" select="Channel/StatusLed/@Off" />
            <xsl:with-param name="ColorPicker" select="false" />
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var onoffswitchId = 'onoffswitch-' + dataset.containerIndex + '-' + dataset.channelIndex;

        eventsOnTile(tileId);

        registerToggleSwitchButton(dataset.statusId, onoffswitchId, tileId, dataset.switchId);

        <xsl:if test="Channel/StatusLed/@Enable = 'true'">
          registerLedCaseSet(dataset.statusId, dataset.ledOn, dataset.ledOff, tileId);
        </xsl:if>
        <xsl:if test="Channel/StatusValue/@Enable = 'true'">
          registerStatusValueCaseSet(dataset.brightnessStatusId, tileId);
        </xsl:if>

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
