<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- Old static stuff. Just for testing -->
    <div id="overlay" class="pf_body">    
      <div id="content">
        <div class="pf_description-row">
          <div id="pf-statusbar" class="t3lws">
            <xsl:call-template name="statusBar">
              <xsl:with-param name="invert" >true</xsl:with-param>
            </xsl:call-template>
          </div>
          <div class="pf_backBtn t2lws">{{primaryFunctionsButtonBack}}</div>
          <div class="pf_function-name t2ws"><xsl:value-of select="Channel/Description/Language[@Index = 0]"/></div>
          <div class="pf_room-name t2gw"><xsl:value-of select="Channel/ContainerDescription/Language[@Index = 0]" /></div>
        </div>
        <xsl:choose>
          <xsl:when test="Channel/@TypeURN = 'de.gira.schema.channels.Trigger'">
            <xsl:call-template name="primaryFunctionTrigger">
              <xsl:with-param name="detailId" select="'pf_detailId'"/>
              <xsl:with-param name="divclass" select="'pf_detail'"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="Channel/@TypeURN = 'de.gira.schema.channels.Sceneextension'">
            <xsl:call-template name="primaryFunctionScene">
              <xsl:with-param name="detailId" select="'pf_detailId'"/>
              <xsl:with-param name="divclass" select="'pf_detail'"/> 
            </xsl:call-template>
          </xsl:when>
        </xsl:choose>
      </div>
      <script type="text/javascript">
        ko.applyBindings(tsx.StatusbarController, $('#pf-statusbar')[0]);
      </script>
    </div>
  </xsl:template>

  <!--
    Creates the trigger primary function view
    -->
  <xsl:template name="primaryFunctionTrigger">
    <xsl:param name="detailId" />
    <xsl:param name="divclass" />
    <div class="detail">
      <xsl:attribute name="id">
        <xsl:copy-of select="$detailId" />
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:copy-of select="$divclass" />
      </xsl:attribute>
      <xsl:attribute name="data-trigger-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Trigger']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='State']/@Id"/>
      </xsl:attribute>
      <div class="trigger-container">
        <div>
          <xsl:attribute name="class">
            <xsl:text>primary-button</xsl:text>
          </xsl:attribute>
          <xsl:if test="Channel/StatusTexts/@Enable = 'true'">
            <span class="trigger-text-off t1ws">
              <xsl:value-of select="Channel/StatusTexts/Off" />
            </span>
            <span class="trigger-text-on t1ws">
              <xsl:value-of select="Channel/StatusTexts/On" />
            </span>
          </xsl:if>
          <xsl:if test="Channel/StatusLed/@Enable = 'false'">
            <div>
              <xsl:attribute name="class">
                <xsl:text>sprites {{primary-function-button}} </xsl:text>
              </xsl:attribute>
            </div>
          </xsl:if>
        </div>
        <xsl:if test="Channel/StatusLed/@Enable = 'true'">
          <div>
            <xsl:attribute name="class">
              <xsl:text>trigger-ring ring1 sprites {{statusring-</xsl:text>
              <xsl:value-of select="Channel/StatusLed/@On"/>
              <xsl:text>}}</xsl:text>
            </xsl:attribute>
          </div>
          <div>
            <xsl:attribute name="class">
              <xsl:text>trigger-ring ring2 sprites {{statusring-</xsl:text>
              <xsl:value-of select="Channel/StatusLed/@Off"/>
              <xsl:text>}}</xsl:text>
            </xsl:attribute>
          </div>
        </xsl:if>
      </div>
    </div>

    <script type="text/javascript">
      (function(){
      var detailId = '#<xsl:copy-of select="$detailId" />';
      var dataset = document.getElementById('<xsl:copy-of select="$detailId" />').dataset;
      primaryFunction.eventsOnPrimFuncTrigger(detailId, dataset.triggerId);

      <xsl:if test="Channel/StatusTexts/@Enable = 'true' or Channel/StatusLed/@Enable = 'true'">
        initTriggerButtonState(parseInt(ComClient.getTagValue(dataset.statusId),10), detailId);
        temporaryCaseSets.push(new CaseSet(dataset.statusId, CaseSetType.CONTENT)
        .addCase(new Case().setExpectedValue(1).setNewValue(true))
        .addCase(new Case().setExpectedValue(0).setNewValue(false))
        .setOnValueFunction(function(value) {
        changeTriggerButtonState(value, detailId);
        })
        );
      </xsl:if>
      })();
    </script>

  </xsl:template>
  
   <!--
    Creates the scence primary function detail view
    -->
  <xsl:template name="primaryFunctionScene">
    <xsl:param name="detailId" />
    <xsl:param name="divclass" />
    <div class="detail">
      <xsl:attribute name="id">
        <xsl:copy-of select="$detailId" />
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:copy-of select="$divclass" />
      </xsl:attribute>
      <xsl:attribute name="data-scene-no-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SceneNo']/@Id"/>
      </xsl:attribute>
      <div class="trigger-container">
        <div>
          <xsl:attribute name="class">
            <xsl:text>primary-button</xsl:text>
          </xsl:attribute>
          <span class="trigger-text-off t1ws">{{primaryFunctionsButtonRetrieve}}</span>
          <div>
            <xsl:attribute name="class">
              <xsl:text>sprites {{primary-function-button}}</xsl:text>
            </xsl:attribute>
          </div>
        </div>
        <div>
          <xsl:attribute name="class">
            <xsl:text>trigger-ring ring1 sprites {{statusring-0}}</xsl:text>
          </xsl:attribute>
        </div>
        <div>
          <xsl:attribute name="class">
            <xsl:text>trigger-ring ring2 sprites {{statusring-2}}</xsl:text>
          </xsl:attribute>
        </div>
      </div>
    </div>

    <script type="text/javascript">
      (function(){
      var detailId = '<xsl:copy-of select="$detailId" />';
      var dataset = document.getElementById(detailId).dataset;
      primaryFunction.eventsOnPrimFuncSceneTrigger('#'+detailId, dataset.sceneNoId);
      })();
    </script>

  </xsl:template>
</xsl:stylesheet>