<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div id="overlay" class="pf_body">    
      <div id="content">
        <div class="pf_description-row">
          <div id="pf-statusbar" class="t3lws">
            <xsl:call-template name="statusBar">
              <xsl:with-param name="invert" >true</xsl:with-param>
            </xsl:call-template>
          </div>
        </div>
        <div class="headline">
          <span class="main-text t3ws"></span>
          <span class="overlay-countdown-text t3lws">
            <xsl:text>{{overlayCountDownText1}}</xsl:text>
            <span class="overlay-countdown"></span>
            <xsl:text>{{overlayCountDownText2}}</xsl:text>
          </span>
        </div>
        <div class="hr"></div>
        <div class="description-text t2ws"></div>
        <div class="spinner" style="display: none;"></div>
        <div class="cancelbutton" style="display: none;"></div>
      </div>
      <script type="text/javascript">
        ko.applyBindings(tsx.StatusbarController, $('#pf-statusbar')[0]);
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>