<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html"/>
    <xsl:template match="/">
        <div id="info-overlay">
            <div id="info-description-row">
                <div class="info-caption t1sw">
                    <xsl:value-of select="/helpPage/caption"/>
                </div>
                <div class="info-subcaption t1gw">
                    <xsl:value-of select="/helpPage/subcaption"/>
                </div>
            </div>
            <div id="animatedHelpContent">
                <div id="info-view-element-box">
                    <div class="info-view-element-box-buttonbar">
                        <div class="cssButton158 inactive btnLeft">
                            <div class="btnText">{{langInfoOverview}}</div>
                        </div>
                        <div class="cssButton158 inactive btnRight">
                            <div class="btnText">{{langInfoLiveHelp}}</div>
                        </div>
                    </div>
                    <div class="info-view-element-box-white-line"></div>
                    <div class="info-fade-out sprites {{{{gc4_help_fadeout_bg}}}}"></div>
                </div>
                <div id="info-view">
                    <div class="container">
                        <div class="info-swiper-container">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="info-view-container-spacer"></div>
                                    <div class="info-view-container-spacer-large"></div>
                                    <div class="text t2lsg introduction">
                                      <xsl:value-of select="/helpPage/introduction"/>
                                    </div>
                                    <xsl:for-each select="/helpPage/paragraph">
                                      <xsl:if test="@title">
                                        <div class="info-view-container-spacer-large-end"></div>
                                        <div class="info-grid-line {{{{info-grid-line}}}} info-grid-line-large"></div>
                                        <div class="text t2sg paragraph-title">
                                          <xsl:value-of select="@title"/>
                                        </div>
                                        <div class="info-grid-line {{{{info-grid-line}}}} info-grid-line-large"></div>
                                        <div class="info-view-container-spacer-small"></div>
                                      </xsl:if>
                                      <div class="text">
                                      <xsl:for-each select="text">
                                        <xsl:choose>
                                           <xsl:when test="@type = 'img'">
                                             <span>
                                               <xsl:attribute name="class">paragraph-icon sprites {{<xsl:value-of select="."/>}}</xsl:attribute>
                                            </span>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <span class="t2lsg paragraph-text">
                                              <xsl:value-of select="."/>
                                            </span>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </xsl:for-each>
                                      </div>
                                    </xsl:for-each>
                                  <div class="info-view-container-end-spacer"></div>
                                </div>
                              
                            </div>
                        </div>
                        <div class="info-swiper-scrollbar"></div>
                    </div>
                </div>
            </div>
        <script type="text/javascript">
            $(function(){
            var mySwiper = $('.info-swiper-container').swiper({
            mode:'vertical',
            loop:false,
            scrollContainer: true,
            simulateTouch: !(("ontouchstart" in document.documentElement) || navigator.userAgent === 'Selenium'),
            calculateHeight: true,
            grabCursor: true,
            mousewheelControl: true,
            scrollbar: {
            container : '.info-swiper-scrollbar',
            draggable : true,
            hide: true,
            snapOnRelease: true
            }
            });
            });
        </script>
      </div>
    </xsl:template>
</xsl:stylesheet>
