/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function TimeZoneViewModel(translate) {
        var timeZones =  ko.observableArray(),
            selected = ko.observable(),
            selectedIcon = ko.observable(""),
            selectedGdsId = ko.observable(),
            mapping = [],
            background = ko.observable("icon-timezones_bg");

        function init(timeZoneIds) {
            var mappedTimeZones;
            selected(undefined);
            mapping = JSON.parse($.ajax({
                url: "setup-wizard/timeZoneMapping.json",
                async: false
            }).responseText);

            mappedTimeZones = _.map(timeZoneIds, function (timeZoneId) {
                var mappedZone = mapping[timeZoneId];
                return {timeZoneId: timeZoneId, zone: mappedZone.zone, zoneName: mappedZone.zoneName, description: translate.i18n(mappedZone.descId)};
            });
            timeZones(mappedTimeZones);
        }

        selected.subscribe(function (timeZoneId) {
            var selectedTimeZone = mapping[timeZoneId];
            if (!timeZoneId) {
                selectedIcon("");
                selectedGdsId("");
                return;
            }
            selectedIcon(selectedTimeZone.icon);
            selectedGdsId(selectedTimeZone.gdsId);
        });

        return {
            pageTitle: translate.i18n('pageTimeZoneTitle'),
            pageInfo: translate.i18n('pageTimeZoneInfo'),
            timeZones: timeZones,
            selected: selected,
            selectedIcon: selectedIcon,
            background: background,
            selectedGdsId: selectedGdsId,
            init: init,
            isValid: function () { return !!selected(); }
        };
    }

    ns.TimeZoneViewModel = TimeZoneViewModel;

}(window, ko));