/*jslint todo: true browser: true*/
/*global */
(function (ns) {
    "use strict";

    function Languages() {
        var translationManager = new window.Gira.LanguageManager(),
            instance = {};

        function registerLanguages() {
            instance.appI18nTexts = translationManager.register("appI18nTexts", "gira-app.json");
        }

        function register(langName, jsonfFilePath) {
            instance[langName] = translationManager.register(langName, jsonfFilePath);
        }

        function getLanguageConfig() {
            return translationManager.getCurrentConfig();
        }

        function registerAdditionalFunctions() {
            instance.register = register;
            instance.getLanguageConfig = getLanguageConfig;
            instance.reLoadLangConfig = translationManager.reLoadLangConfig;
        }

        registerLanguages();
        registerAdditionalFunctions();

        return instance;
    }

    ns.Languages = Languages;
    ns.appLang = new Languages();
}(window.Gira));