/**
 * This module handles the wifi list.
 */
tsx.WifiSettings = (function ()
{
    var wifi = {},
        I18nTexts = window.Gira.appLang.appI18nTexts;
    wifi.signalStrength0Icon = '';
    wifi.signalStrength25Icon = '';
    wifi.signalStrength50Icon = '';
    wifi.signalStrength75Icon = '';
    wifi.signalStrength100Icon = '';
    wifi.connectedIcon = '';
    wifi.disconnectedIcon = '';
    wifi.securityIcon = '';
    wifi.connectedWifi = {identifier: ''};

    function network(ssid, connected, security, signalStrength, identifier) {
        var self = this;
        if (ssid != false) {
            self.ssid = ssid;
        } else {
            self.ssid = null;
        }
        //== false ? "nicht konfiguriert" : ssid;

        self.networkSecurity = security;
        self.identifier = identifier;

        self.ssidCss = ko.computed(function() {
            if (ssid === false) {
                return "inactive";
            }
        });
        self.connected = ko.computed(function () {
            if (ssid != false) {
                return connected == "true" ? wifi.connectedIcon : wifi.disconnectedIcon;
            } else {
                return "";
            }
        });
        self.security = ko.computed(function () {
            if (security != "none") {
                return wifi.securityIcon;
            } else {
                return "";
            }
        });
        self.signalStrength = ko.computed(function () {
            signalStrength = parseInt(signalStrength);
            if (signalStrength === 0) {
                return wifi.signalStrength0Icon;
            } else if (signalStrength > 0 && signalStrength <= 25) {
                return wifi.signalStrength25Icon;
            } else if (signalStrength > 25 && signalStrength <= 50) {
                return wifi.signalStrength50Icon;
            } else if (signalStrength > 50 && signalStrength <= 75) {
                return wifi.signalStrength75Icon;
            } else if (signalStrength > 75 && signalStrength <= 100) {
                return wifi.signalStrength100Icon;
            }
        });
    }

    wifi.discoveredNetworksViewModel = function() {
        var self = this;

        self.connectedNetwork = ko.observableArray([]);
        self.networks = ko.observableArray([]);
        self.wifiActive = ko.observable(false);

        self.getAvailableNetworks = function() {
            var triggerScanObj = {};
            triggerScanObj.NetworkTechnologies_wifi_TriggerScan = "true";
            wifi.connectedWifi.identifier = '';
            gds$.setDeviceConfigurationValue(true, triggerScanObj);
            setTimeout(function () {
                gds$.updateDeviceConfiguration(false, function (config) {
                    var networkServices = config.networkServices;
                    var savedSSID = localStorage['WLAN_SSID'];
                    var savedIdentifier = localStorage['WLAN_IDENTIFIER'];
                    var savedSecurity = localStorage['security'];
                    var connected = false;
                    self.removeAllNetworks();

                    if (networkServices) {
                        networkServices.forEach(function (entry) {
                            if (entry.technology === "wifi" && entry.connected === "true" && connected === false && entry.name !== "") {
                                connectedNetwork.removeAll();
                                connectedNetwork.push(new network(entry.name, entry.connected, entry.security, entry.strength, entry.identifier));
                                wifi.connectedWifi.identifier = entry.identifier;
                                connected = true;
                            } else if (entry.technology === "wifi" && entry.connected === "false" && entry.name !== "") {
                                networks.push(new network(entry.name, false, entry.security, entry.strength, entry.identifier));
                            }
                        });
                    }

                    if (connectedNetwork().length === 0) {
                        if (typeof savedSSID === "undefined") {
                            connectedNetwork.push(new network(false, "false", "none", ""));
                        } else {
                            connectedNetwork.push(new network(savedSSID, false, savedSecurity, "0", savedIdentifier));
                        }
                    }

                    updateSwiper();
                });
            }, 2000);
        };

        self.updateSwiper = function() {
            $(menuId).data('settingsSwiper').resizeFix(true);
        };

        self.initNetworks = function() {
            self.removeAllNetworks();
            self.getAvailableNetworks();
            self.updateSwiper();
        };

        self.removeAllNetworks = function() {
            connectedNetwork.removeAll();
            networks.removeAll();
        };

        self.registerEvents = function(element, network) {
            var div = $(element).filter('div');

            $(div).data('network', network);
            $(div).on('settingsEntryAction', function() {
                var settingRows = $('.settings-row');
                $(settingRows).each(function(index, element) {
                    if ($(element).attr('submenuid')) {
                        if (network.ssid) {
                            openSettingsElement(menuId.replace(/#/, ''), $(element).attr('submenuid'), function () { tsx.WifiConnectionSettings.onWifiEntryClick($(div).data('network'));  });
                        }
                        return;
                    }
                });
            });
            if (network.ssid) {
                eventsOnSettingsEntry($(div));
            }
        };

        self.initNetworks();
};



    wifi.wpsNetworks = (function () {
        var self = this;
        var module = {};
        var title = I18nTexts.wifiSettingsWpsNetworkTitle;

        module.wpsNetworks = ko.observableArray([]);
        module.selectedNetwork = ko.observable();
        module.isValid = ko.computed(function () {
            return module.selectedNetwork() !== undefined;
        });

        module.init = function() {
            setTitle();
            getWpsNetworks();
        };

        function setTitle() {
            $(menuId + ' .settings-title').text(title);
        }

        function getWpsNetworks() {
            module.wpsNetworks([]);
            module.selectedNetwork(undefined);
            gds$.updateDeviceConfiguration(false, function(config) {
                var networkServices = config.networkServices;
                if (networkServices) {
                    networkServices.forEach(function(entry) {
                        var securityValues = entry.security.split(' ');

                        if (securityValues.indexOf('wps') !== -1)
                            module.wpsNetworks.push(entry);
                    });
                }
                $(menuId).data('settingsSwiper').resizeFix(true);
            });
        }

        module.registerEvents = function (element, network) {
            eventsOnSettingsEntry(network.identifier);
            $(element[1]).on('settingsEntryAction', function() {
                $("input", this).prop("checked", true);
                module.selectedNetwork(network);
            });
        };

        module.ok = function () {
            NavbarController.getInstance().addBackFunction(function() {
                 tsx.WifiConnectionSettings.openWifiOverlay(module.selectedNetwork());
            });
        };

        return module;
    })();

    return wifi;
})();