﻿/**
 * Event handling for up and down buttons
 * 
 * @param {string} buttonId button id
 * @param {int}    step step size for increment / decrementing the blind position
 * @param {object} context blindAbsoluteTile context
 */
function BlindAbsoluteButton(tileId, buttonId, step, context) {

    var self = this;
    var button = $('#' + buttonId);
    var buttonImg = $('#' + buttonId + ' .sliderbutton-label');
    var buttonFg = $('#' + buttonId + '>.sliderButton-fg');
    var buttonBg = $('#' + buttonId + '.sliderButton-bg');

    this._timeoutMouseDown = 0;
    this._longPressFlag = 0;
    this._step = step < 0 ? 0 : 100;
    this._c = context;

    registerEventsForSwipeableElement(
        button,
        function ()	//down 
        {
            // no action if button is disabled
            if (button.hasClass('disabled')) {
                return;
            }
            onControlDownChangeTileBackground(tileId);
            buttonBg.addClass('sliderbutton-bg-down');
            buttonFg.addClass('sliderbutton-fg-down');
            self._timeoutMouseDown = setTimeout(function () {
                self._longPressFlag = 1;
                //start	automatic mode
                self._c._startAutomatic(self._step);
                ComClient.sendTagValue(self._c._DPHeightPosition, self._step);
            }, 500);
        },
        function () // release 
        {
            onControlReleaseChangeTileBackground(tileId);
            buttonBg.removeClass('sliderbutton-bg-down');
            buttonFg.removeClass('sliderbutton-fg-down');

            window.clearTimeout(self._timeoutMouseDown);
        },
        function () // click 
        {
            // no action if button is disabled
            if (button.hasClass('disabled')) {
                return;
            }
            var value = 0;
            if (self._longPressFlag !== 0)  //long release
            {
                self._longPressFlag = 0;
            }
            else	//short release
            {
                if (self._c._automatic === false) {
                    value = Round(self._c._userValue, undefined);
                    if (isNaN(value)) {
                        if (step > 0) {
                            value = 100;
                        } else {
                            value = 0;
                        }
                    } else {
                        value += step;
                        if (value < 0) value = 0;
                        if (value > 100) value = 100;
                    }
                    self._c._userValue = value;

                    ComClient.sendTagValue(self._c._DPHeightPosition, value);

                    self._c._onHeightStatusValue(value, 0);
                    self._c.setBtnStatus(value);
                }
                else {
                    //stop
                    self._c._stopAutomatic();
                    ComClient.sendTagValue(self._c._DPStop, 1);
                }
            }
        }
    );

    /**
     * Sets enabled state for button.
     * 
     * @param {boolean} buttonId enables or disables button.
     */
    this.setEnabled = function(isEnabled) {
        if (isEnabled) {
            buttonImg.removeClass(buttonImg.attr('inactive')).addClass(buttonImg.attr('enabled'));
            button.removeClass('disabled');
        } else {
            buttonImg.removeClass(buttonImg.attr('enabled')).addClass(buttonImg.attr('inactive'));
            button.addClass('disabled');
        }
    };
};