tsx.BlindAbsolute = (function () {
    var module = {};

    /**
     * Eventlistener for stop buttons
     * mouse and touch events
     * 
     * @param {string} detail detail id of button container
     * @param {string} tag tag of stop datapoint
     * @returns {undefined}
     */
    module.eventsOnStop = function (detailId, tag) {
        var stopBtn = $(detailId).find('.stopBtn');
        var stopButtonFg = $(detailId).find('.stopBtn > .sliderButton-fg');

        registerEventsForPressButton(stopBtn,
            function() {
                stopBtn.addClass('sliderbutton-bg-down');
                stopButtonFg.addClass('sliderbutton-fg-down');
            },
            function() {
                stopBtn.removeClass('sliderbutton-bg-down');
                stopButtonFg.removeClass('sliderbutton-fg-down');
            },
            function() {
                stopBtn.attr('onclick', '').unbind('click');
                ComClient.sendTagValue(tag, 1);
            }
        );
    }
    return module;
})();