/*jslint browser: true*/
/*global console, Gira, $, getConnectionInfo*/

(function (ns) {
    'use strict';

    if (ns.gdsConnection) {
        return;
    }

    if (!ns.Log || !ns.DcsToGdsConnector) {
        throw new Error("Required javascript is not loaded before load module loader ((gira.log.js, gira.gdsConnector.js, gira.gdsConnectionWrapper.js))!");
    }

    // Load html into body surrounded with hidden div tag.
    function loadModuleHtml(divId, filePath) {
        var hiddenDiv = $('<div id="' + divId + '" style="display: none"></div>');
        $(document.body).append(hiddenDiv);
        hiddenDiv.load(filePath);
    }

    function init() {
        var Gira = window.Gira,
            connectionInfo = getConnectionInfo(),
            connection = new Gira.GdsConnectionWrapper(connectionInfo.ip),
            gdsConnector = new Gira.DcsToGdsConnector(Gira.Globals.ApplicationName, false, connection);

        Gira.ConfigLoader.init(gdsConnector);

        loadModuleHtml("giraTemplates", "gira/gira.templates.html");

        ns.gdsConnection = gdsConnector;

        Gira.Log.setGdsConnection(gdsConnector);
    }

    ns.ModuleLoader = {
        init: init
    };

}(window.Gira));

//# sourceURL=gira.moduleLoader.js