/*global window, navbarController, Gira, NavbarController, fsm, $, setTimeout*/

(function (ns) {
    'use strict';
    var DCS = window.Gira.DCS,
        Urns = DCS.Urns;
    function TileController(onBackCallback, tkFsm) {
        var self = this,
            isOpen = false,
            fsm = tkFsm,
            externalOnBack = onBackCallback,
            navigationBarController = NavbarController.getInstance(),
            onBack = function () {
                externalOnBack();
                isOpen = false;
            };
        self.openTksView = function (tksViewLocation, backView) {
            var rebind = function (rootElement) {
                    var dcsContent = $("<div class ='world' id='dcs-content' data-bind='template: {name: \"dcs-template\"}'></div>");
                    dcsContent.on("remove", function () {
                        onBack();
                    });
                    rootElement.append(dcsContent);
                    DCS.Bootstrapper.rebindTo(dcsContent);
                };
            navigationBarController.loadWorld(tksViewLocation, backView, onBack, false, rebind);
            isOpen = true;
        };
        self.applyData = function (data) {
            if (Urns.isIncomingDoorCall(data) || Urns.isOutgoingCameraCall(data) || Urns.isOutgoingDoorStationCall(data) || Urns.isVideoStreamIndex(data.urn)) {
                fsm.Close();
                fsm.Open();
                if (!isOpen) {
                    self.openTksView("templates/tks_view.xhtml", navigationBarController._currentLocation);
                }
            } else {
                if (Urns.isIdle(data) || Urns.isNoConnectionToDcs(data)) {
                    fsm.Close();
                }
            }
        };
        // This is needed for the gira app: when only the TKS is shown, we should not open the module
        self.isAlwaysOpen = function () {
            isOpen = true;
        };
        fsm.Init();
    }
    ns.TileController = TileController;
}(Gira.DCS.Controller));

//# sourceURL=dcs.tile.controller.js