#!/bin/bash
#
# Reboot script called by GDS.
# - writes values from files in EXTPARAM to UBoot environment variables.
# - sets UBoot environment variable is_reboot to 1 (one) to let UBoot know
#   it's a GDS requested reboot thus leaving bootcounters untouched.
#

source /opt/gira/share/devicestack/ipmodule-vars

me="gds-reboot.sh"

CALLER=$(ps | grep "^ *$PPID" | awk '{print $NF}')
logger -s "[$me] Called by: ${CALLER}"

logger -s "[$me] Synchronizing settings before restart."

/opt/gira/bin/sync-eth0-mac-address.sh
/opt/gira/bin/sync-wlan0-mac-address.sh
/opt/gira/bin/sync-uid.sh

${ENVIRONMENT_SYNC_SCRIPT}

logger -s "[$me] Settings is_reboot to 1."
fw_setenv is_reboot 1

# Actually reboot.
logger -s "[$me] Calling system reboot!"
${REBOOT}

exit 0
