/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function LanguageSelectionViewModel(translate) {
        var self = this;

        self.languages = ko.observableArray([
            {value: "de", name: "Deutsch"},
            {value: "en", name: "English"},
            {value: "da", name: "Dansk"},
            {value: "fi", name: "Suomi"},
            {value: "fr", name: "Français"},
            {value: "el", name: "ελληνικά"},
            {value: "is", name: "Icelandic"},
            {value: "it", name: "Italiano"},
            {value: "lv", name: "Latviešu"},
            {value: "nl", name: "Nederlands"},
            {value: "no", name: "Norsk"},
            {value: "pl", name: "Polski"},
            {value: "pt", name: "Português"},
            {value: "ro", name: "Romana"},
            {value: "ru", name: "русский"},
            {value: "sv", name: "Svenska"},
            {value: "zh", name: "简体中国"},
            {value: "sk", name: "Slovenský"},
            {value: "sl", name: "Slovenščina"},
            {value: "es", name: "Español"},
            {value: "cz", name: "Český"},
            {value: "hu", name: "Magyar"}
        ]);
        self.selected = ko.observable("de");
        self.pageTitle = translate.i18n('pageLanguageTitle');
        self.pageInfo = translate.i18n('pageLanguageInfo');
        self.background = ko.observable("icon-continent_bg");
        self.selectedIcon = ko.observable("");

        self.selected.subscribe(function (language) {
            translate.changeLanguage(language);
        });
        self.isValid = function () { return true; };
    }

    ns.LanguageSelectionViewModel = LanguageSelectionViewModel;

}(window, ko));