/*global ko*/
/*jslint browser: true*/
(function (ns) {
    "use strict";
    var LAN = "LAN",
        WLAN = "WLAN";

    function NetworkModel(networkInterface, i18nTexts, fsm) {
        var selected = ko.observable(),
            initState;

        function hasChanged() {
            return initState !== selected();
        }

        return {
            init: function () {
                networkInterface.on(networkInterface.events.onWifiChanged, function (isWifiOn) {
                    initState = isWifiOn ? WLAN : LAN;
                    selected(initState);
                });
            },
            ok: function () {
                if (hasChanged()) {
                    fsm.OpenConfirmation(i18nTexts.menuConfigNetworkTypeConfirmMessage,
                        function () {
                            var useWifi = selected() === WLAN;
                            networkInterface.network.wifi.isWifiOn(useWifi);
                            networkInterface.rebootDevice();
                        },
                        // cancel button: close popup
                        function () {
                            fsm.CloseConfirmation();
                        });
                    return false;
                }
                return true;
            },
            cancel: function () { return undefined; },
            networks: ko.observableArray([{label: i18nTexts.menuConfigNetworkTypeLANText, value: LAN}, {label: i18nTexts.menuConfigNetworkTypeWLANText, value: WLAN}]),
            selected: selected,
            i18nTexts: i18nTexts
        };
    }
    ns.NetworkModel = NetworkModel;
}(window.Gira));

