﻿var RtcTile = (function () {

    var module = {};

    var btnDown;
    var btnUp;
    var btnDownDisabled;
    var btnUpDisabled;
    var temp;
    var text;

    module.init = function (tileId, dataset) {
        var tile = $('#' + tileId);
        var suffix = dataset.containerIndex + '-' + tileId;

        btnDown = tile.find('.RTR_tile_button').not('.disabled');
        btnUp = tile.find('.RTR_tile_button_right').not('.disabled');
        btnDownDisabled = tile.find('.RTR_tile_button.disabled');
        btnUpDisabled = tile.find('.RTR_tile_button_right.disabled');
        text = tile.find('.tile-status-text');

        registerRtcButton(dataset.setpointTemperatureShiftUpId, 'RTR_plus-' + suffix, tileId);
        registerRtcButton(dataset.setpointTemperatureShiftDownId, 'RTR_minus-' + suffix, tileId);
        registerCaseSets(dataset, tileId);
    };

    module.setTemp = function (value) {
        var minTemp = rtc.getOptsMinTemp(),
            maxTemp = rtc.getOptsMaxTemp();
        temp = undefined;
        if (isValidValue(value)){
            temp = value * 10;
        }
        if (temp > maxTemp) {
            temp = maxTemp;
        } else if (temp < minTemp) {
            temp = minTemp;
        }
        text.html(formatTemperatureValue((temp / 10).toFixed(1)));
        if (!rtc.isRtcLocked()) module.setRTCButtonStates(temp);
    };

    /**
     * Registers events for the tile rtc inrement / decrement buttons
     *
     * @param {string} datapoint
     *			Datapoint to send trigger values
     * @param {string} buttonId
     *			Id button
     * @param {string} tileId
     *			Id of the value trigger tile
     */
    function registerRtcButton (datapoint, buttonId, tileId) {
        var button = $('#' + buttonId);
        var buttonFg = button.find('.sliderbutton-fg');
        var buttonBg = button;
        var buttonLabel = button.find('> .tile-trigger-button > .sliderbutton-label')[0];

        registerEventsForPressButton(button,
            function () {
                onControlDownChangeTileBackground(tileId);
                buttonBg.addClass('sliderbutton-bg-down');
                buttonFg.addClass('sliderbutton-fg-down');
                spriteDown(buttonLabel);
                rtc.startLongPress(function () {
                    ComClient.sendTagValue(datapoint, 1);
                });
            },
            function () {
                onControlReleaseChangeTileBackground(tileId);
                buttonBg.removeClass('sliderbutton-bg-down');
                buttonFg.removeClass('sliderbutton-fg-down');
                spriteUp(buttonLabel);
                rtc.releaseLongPress();

            },
            function () {
                if (!rtc.longPressInterval) {
                    ComClient.sendTagValue(datapoint, 1);
                }
            }
        );
    };

    /**
     * Set RTC tile buttons +/- enabled state
     *
     * @param {string} tileId
     *			Id of the RTC tile
     * @param {int} min
     *			minimum allowed value
     * @param {int} max
     *			maxium allowed value
     * @param {int} value
     *			Id of the RTC tile
    */
    module.setRTCButtonStates = function (value) {
        if (!rtc.isThermalProtectionActive() && !rtc.isRtcLocked()) {
            if (!isValidValue(value)) {
                btnUp.hide();
                btnUpDisabled.show();
                btnDown.hide();
                btnDownDisabled.show();
                return;
            }
            if (value <= rtc.getOptsMinTemp()) {
                rtc.releaseLongPress();
                btnUp.show();
                btnUpDisabled.hide();
                btnDown.hide();
                btnDownDisabled.show();
            } else if (value >= rtc.getOptsMaxTemp()) {
                rtc.releaseLongPress();
                btnUp.hide();
                btnUpDisabled.show();
                btnDown.show();
                btnDownDisabled.hide();
            } else {
                btnUp.show();
                btnUpDisabled.hide();
                btnDown.show();
                btnDownDisabled.hide();
            }
        }
    };

    /**
     * Set RTC tile buttons +/- enabled state
     *
     */
    module.updateRtcButtonStates = function () {
        var disabled = rtc.isRtcLocked() || rtc.isThermalProtectionActive();
        if (disabled) {
            btnUp.hide();
            btnDown.hide();
            btnUpDisabled.show();
            btnDownDisabled.show();
        } else {
            module.setRTCButtonStates(temp);
        }

    };

    /**
     *  Registers events for the tile heating and cooling status, temperature, operation mode and lock state
     *
     * @param {object} dataset
     *			tile template dataset
     * @param {string} tileId
     *			Id of the RTC tile
    */
    function registerCaseSets(dataset, tileId) {

        var coolingSymbol = $('#' + tileId).find("[id*='RTR_cooling']");
        var heatingSymbol = $('#' + tileId).find("[id*='RTR_heating']");
        var isControllerOperationLock = dataset.controllerOperationLocked === 'true';

        temporaryCaseSets.push(new CaseSet(dataset.heatingStatusId, CaseSetType.VALUE)
            .setOnValueFunction(function(value) {
                if (value > 0) {
                    heatingSymbol.show();
                    coolingSymbol.hide();
                } else heatingSymbol.hide();
            })
        );

        temporaryCaseSets.push(new CaseSet(dataset.coolingStatusId, CaseSetType.VALUE)
            .setOnValueFunction(function(value) {
                if (value > 0) {
                    coolingSymbol.show();
                    heatingSymbol.hide();
                } else coolingSymbol.hide();
            })
        );

        temporaryCaseSets.push(new CaseSet(dataset.setpointTemperatureStatusId, CaseSetType.VALUE)
          .setOnValueFunction(function (value) {
              module.setTemp(value);
          })
          );

        temporaryCaseSets.push(new CaseSet(dataset.operationModeStatusId, CaseSetType.VALUE)
          .setOnValueFunction(function (value) {
              rtc.setThermalProtectionActive(parseInt(value) == 4);
              module.updateRtcButtonStates();
          })
          );

        if (isControllerOperationLock) {
            // controllerOperationLockStatus case set
            temporaryCaseSets.push(new CaseSet(dataset.controllerOperationLockStatusId, CaseSetType.VALUE)
            .setOnValueFunction(function (value) {
                rtc.setRtcLock(parseInt(value) == 1);
                module.updateRtcButtonStates();
            })
            );
        }

    };

    return module;
})();