/*jslint browser: true*/
/*global ko, $, _*/
(function (ns) {
    "use strict";
    var DCS = window.Gira.DCS,
        Messages = DCS.Messages,
        Urns = DCS.Urns,
        Globals = DCS.Globals,
        SettingsKey = "dcs.settings";

    function Settings(gdsConnection, configuration, callResolveUrns, statusBarController) {
        var self = this,
            config = configuration,
            needSendSetConfiguration = false,
            connection = gdsConnection,
            resolveUrns = callResolveUrns,
            connectedToDcs = false;

        function reloadSettings() {
            connection.sendMessage(Messages.getAppValue(SettingsKey));
        }

        function getSettingsObjectForSendMessage() {
            var data = {};
            _.extend(data, self.connectionInfo.getPersistedData());
            _.extend(data, self.automaticDoorOpener.getPersistedData());
            return _.reduce(self.audioModels, function (merged, audioModel) { return _.extend(merged, audioModel.getPersistedData()); }, data);
        }

        function fillSettingsModel(message) {
            var newSettings = message.value ? JSON.parse(message.value) : {ip: "", username: "", password: ""};
            self.connectionInfo.init(newSettings);
        }

        function invokeReconnectToDcs(connectionInfo) {
            connection.sendMessage(Messages.setConfiguration(connectionInfo.ipAddress, connectionInfo.userName, connectionInfo.password));
            connection.sendMessage(Messages.setValue(Urns.connect, "0"));
            setTimeout(function () {
                connection.sendMessage(Messages.setValue(Urns.connect, "1"));
            }, 2000);
        }

        function saveCallback(messages, saveSettings, reconnectToDcs, delayedMessages) {
            messages.forEach(function (message) { connection.sendMessage(message); });
            if (saveSettings) {
                connection.sendMessage(Messages.setAppValue(SettingsKey,
                    JSON.stringify(getSettingsObjectForSendMessage())));
            }
            if (delayedMessages !== undefined) {
                delayedMessages.forEach(function (message) {
                    setTimeout(function () {
                        connection.sendMessage(message);
                    }, 2000);
                });
            }
            if (reconnectToDcs !== undefined && reconnectToDcs !== false) {
                invokeReconnectToDcs(reconnectToDcs);
            }
        }

        function cancelCallback() {
            connection.sendMessage(Messages.getAppValue(SettingsKey));
            connection.sendMessage(Messages.getMenuConfiguration());
        }

        function setVisibleFlag(isVisible) {
            self.automaticDoorOpener.isConnected(isVisible);
            self.doorStations.isVisible((self.doorStations.stations().length > 0) && isVisible);
            self.cameras.isVisible((self.cameras.cameraList().length > 0) && isVisible);
            self.speakerVolume.isVisible(isVisible);
            self.microphoneGain.isVisible(isVisible);
            self.ringToneVolume.isVisible(isVisible);
            self.doorCalls.isVisible(isVisible);
        }

        function hideDcsSetting() {
            setVisibleFlag(false);
            self.connectionInfo.isEnabled(true);
        }

        function processConnectionStates(message) {
            var connectionState;
            if (Urns.isForUrn(Urns.connectionState, message.urn)) {
                connectionState = message.value;
                switch (connectionState) {
                case "3":
                    connectedToDcs = true;
                    break;
                default:
                    connectedToDcs = false;
                    hideDcsSetting();
                    break;
                }
            }
        }

        function processDoorCallMessages(message) {
            if (Urns.isIncomingDoorCall(message) || Urns.isOutgoingDoorStationCall(message)) {
                self.connectionInfo.isEnabled(false);
            } else if (Urns.isIdle(message) || Urns.isNoConnectionToDcs(message)) {
                self.connectionInfo.isEnabled(true);
            }
        }

        self.connectionInfo = new DCS.DcsConnectionInfo(saveCallback, cancelCallback, invokeReconnectToDcs, config.connection);
        self.speakerVolume = DCS.Audio.createSpeakerVolume(saveCallback, cancelCallback, config.audio.speaker);
        self.microphoneGain = DCS.Audio.createMicrophoneGain(saveCallback, cancelCallback, config.audio.microphone);
        self.ringToneVolume = DCS.Audio.createRingToneVolume(saveCallback, cancelCallback, config.audio.ringtone);
        self.automaticDoorOpener = DCS.createAutomaticDoorOpenerOnOff(saveCallback, cancelCallback, config.automaticDoorOpener, statusBarController);
        self.cameras = DCS.Cameras(saveCallback, config.cameras);
        self.doorStations = new DCS.DoorStation(saveCallback, config.doorStations);
        self.doorCalls = DCS.DoorCalls(saveCallback, config.doorCalls);
        self.audioModels = [self.speakerVolume, self.microphoneGain, self.ringToneVolume];
        self.deviceConfig = {name: "", macAddress: ""};

        function initModelsFromMenuConfiguration(menuObj) {
            self.audioModels.forEach(function (audioModel) { audioModel.init(menuObj); });
            self.doorStations.init(menuObj);
            self.cameras.init(menuObj.cameras);
            self.automaticDoorOpener.init(menuObj);
            self.doorCalls.init(menuObj.doorCalls, menuObj.ringTones);
            if (connectedToDcs) {
                setVisibleFlag(true);
            } else {
                hideDcsSetting();
            }
        }

        function fillDeviceConfig(data) {
            self.deviceConfig.name = data.deviceConfig.ipc.DeviceName;
            self.deviceConfig.macAddress = data.deviceConfig.ipc.MacAddress;
            resolveUrns(self.deviceConfig.name);
        }

        function getDeviceConfig() {
            connection.sendMessage(Messages.getDeviceConfig());
        }

        window.onbeforeunload = function () {
            connection.sendMessage(Messages.setValue(Urns.connect, "0"));
        };

        return {
            connectionInfo: self.connectionInfo,
            speakerVolume: self.speakerVolume,
            microphoneGain: self.microphoneGain,
            ringToneVolume: self.ringToneVolume,
            automaticDoorOpener: self.automaticDoorOpener,
            doorStations: self.doorStations,
            audioModels: self.audioModels,
            cameras: self.cameras,
            doorCalls: self.doorCalls,
            apply: function () {
                connection.sendMessage(Messages.getAppValue(SettingsKey));
                connection.sendMessage(Messages.getMenuConfiguration());
            },
            applyData: function (message) {
                var request = message.request,
                    event = message.event,
                    response = message.response,
                    menuObj;
                if (request) {
                    if (request.command === "GetAppValue" && request.appName === Globals.ApplicationName && request.key === SettingsKey) {
                        fillSettingsModel(message);
                        if (needSendSetConfiguration) {
                            needSendSetConfiguration = false;
                            invokeReconnectToDcs({ipAddress: self.connectionInfo.model.ipAddress(), userName: self.connectionInfo.model.userName(), password: self.connectionInfo.model.password()});
                        }
                    } else if (Urns.isResponseForMenuGetConfiguration(message)) {
                        menuObj = Messages.menuConfigToObject(message);
                        initModelsFromMenuConfiguration(menuObj);
                    }
                }
                if (response) {
                    if (self.deviceConfig.name === "" && response.request.command === "GetDeviceConfig" && response.error.text === "OK") {
                        fillDeviceConfig(response);
                        reloadSettings();
                    }
                }
                if (event) {
                    if (Urns.isConfigurationCompleted(message) || Urns.isMenuConfigurationChanged(message)) {
                        connection.sendMessage(Messages.getMenuConfiguration());
                    }
                    processConnectionStates(message);
                    processDoorCallMessages(message);
                }
            },
            onOpen: function () {
                needSendSetConfiguration = true;
                getDeviceConfig();
            },
            ok: function () {
                return undefined;
            },
            cancel: function () {
                return undefined;
            }
        };
    }

    ns.Settings = Settings;
}(window.Gira.DCS));
//@ sourceURL=dcs.settings.js