/*jslint browser: true*/
/*global ko, $, _*/

(function (ns) {
    "use strict";
    var DCS = ns,
        Messages = DCS.Messages;

    function Audio(saveCallbackFunc, cancelCallbackFunc, makeMessagesWithCurrentValue, keyInMenu, config, getAdditionalMessagesFunc) {
        var makeMessages = makeMessagesWithCurrentValue,
            key = keyInMenu,
            saveCallback = saveCallbackFunc,
            cancelCallback = cancelCallbackFunc,
            getAdditionalMessages = getAdditionalMessagesFunc,
            isVisible = ko.observable(false),
            onInit = function () { return undefined; },
            slider =  new DCS.Slider({
                initValue: 20,
                minimum: 10,
                maximum: 100,
                steps: 1,
                elementWidth: 336,
                icons: {
                    scale: 'sprite_336x36_gc4_skala_10-100_h',
                    minimum: config.minIcon,
                    maximum: config.maxIcon
                },
                infoText: config.infoText,
                onValueChangeCallBack: function () {
                    var messages = _.map(makeMessages, function (makeMessage) { return makeMessage(slider.value()); });
                    if (getAdditionalMessages) {
                        getAdditionalMessages().forEach(function (message) { messages.push(message); });
                    }
                    saveCallback(messages, false);
                }
            });

        return {
            init: function (menuObj) {
                this.slider.value(menuObj[key]);
                if (onInit) {
                    onInit(menuObj);
                }
            },
            ok: function () {
                // var currentValue = this.slider.value();
                // saveCallback(_.map(makeMessages, function (makeMessage) { return makeMessage(currentValue); }), false);
                // as wished, the ok button is acting like a cancel-button, because the slider saves the value itself.
                cancelCallback();
            },
            withCancel: false,
            getPersistedData: function () {
                return {};
            },
            isVisible: isVisible,
            slider: slider,
            label: config.label,
            setOnInit: function (func) { onInit = func; }
        };
    }

    function createSpeakerVolume(saveCallbackFunc, cancelCallbackFunc, config) {
        return new Audio(saveCallbackFunc, cancelCallbackFunc, [Messages.setMenuValue.speakerVolume], 'speakerVolume', config);
    }

    function createMicrophoneGain(saveCallbackFunc, cancelCallbackFunc, config) {
        return new Audio(saveCallbackFunc, cancelCallbackFunc, [Messages.setMenuValue.microphoneGain], 'microphoneGain', config);
    }

    function createRingToneVolume(saveCallbackFunc, cancelCallbackFunc, config) {
        var audio,
            selectedRingTone;
        function getAdditionalMessages() {
            if (selectedRingTone) {
                return [Messages.setMenuValue.playRingTone(selectedRingTone.ringTone)];
            }
            return [];
        }
        audio = new Audio(saveCallbackFunc, cancelCallbackFunc, [Messages.setMenuValue.ringToneVolume], 'ringToneVolume', config, getAdditionalMessages);
        audio.setOnInit(function (menuObj) {
            if (menuObj.doorCalls && menuObj.doorCalls[0]) {
                selectedRingTone = menuObj.doorCalls[0];
            } else {
                selectedRingTone = undefined;
            }
        });
        return audio;
    }

    ns.Audio = Audio;
    ns.Audio.createSpeakerVolume = createSpeakerVolume;
    ns.Audio.createMicrophoneGain = createMicrophoneGain;
    ns.Audio.createRingToneVolume = createRingToneVolume;
}(window.Gira.DCS));

//@ sourceURL=dcs.settings.audio.js