#!/bin/sh
### BEGIN INIT INFO
# Provides:          hostname
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Set hostname based on /var/run/hostname
### END INIT INFO

me="hostname.sh"

logger -s "[${me}] Starting ..."

# DEFAULT_HOSTNAME is used in commissioning mode.
DEFAULT_HOSTNAME_PREFIX="IM"
if [ -r "/opt/extparam/ipmodule_id" ]
then
  # overwrite default hostname prefix with IP Module ID, if present
  DEFAULT_HOSTNAME_PREFIX="$(cat /opt/extparam/ipmodule_id)"
fi
HOSTNAME="${DEFAULT_HOSTNAME_PREFIX}"
HOSTNAME_FILE_PATH=/var/run/hostname
MANUFACTURER_ID_FILE="/opt/extparam/manufacturer_id"
DEVICE_ID_FILE="/opt/extparam/device_id"
NETDEV="eth0"
HWADDR_FILE="/sys/class/net/${NETDEV}/address"

# reads the hardware address from the sysfs of given network interface
# in => $NETDEV, $HWADDR_FILE
# out => $HWADDR
if ! [ -r ${HWADDR_FILE} ]
then
  logger -s "[${me}] ${NETDEV} network interface not found."
else
  HWADDR=$(head -n 1 ${HWADDR_FILE} | tr -d ':' | tr '[:lower:]' '[:upper:]' )
fi

# overwrites the hostname prefix if information is available
# out => $HOSTNAME
if [ -r "${MANUFACTURER_ID_FILE}" ] && [ -r "${DEVICE_ID_FILE}" ]
then
  MANUFACTURER_ID=$(cat "${MANUFACTURER_ID_FILE}" | tr -d '\040\011\012\015')
  DEVICE_ID=$(cat "${DEVICE_ID_FILE}" | tr -d '\040\011\012\015')
  HOSTNAME="${MANUFACTURER_ID}${DEVICE_ID}"
fi

if ! [ -z "${HWADDR}" ]
then
  HOSTNAME="${HOSTNAME}-${HWADDR}"
fi

# writes the hostname to the hostname file
echo "${HOSTNAME}" > ${HOSTNAME_FILE_PATH}
logger -s "[${me}] Setting hostname to ${HOSTNAME}"

hostname -b -F ${HOSTNAME_FILE_PATH} 2> /dev/null
if [ $? -eq 0 ]
then
  exit
fi

# Busybox hostname doesn't support -b so we need implement it on our own
if [ -f "${HOSTNAME_FILE_PATH}" ]
then
  hostname -F "${HOSTNAME_FILE_PATH}"
elif [ -z "$HOSTNAME" -o "$HOSTNAME" = "(none)" -o ! -z "`echo $HOSTNAME | sed -n '/^[0-9]*\.[0-9].*/p'`" ]
then
  hostname localhost
fi
