#!/bin/sh
### BEGIN INIT INFO
# Provides:          fix-wlan0-hwaddr.sh
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:      0 6
# Short-Description: Fix wlan0 interface hardware address. In some devices are HD wireless addresses found. This script makes sure that the Gira address is used.
### END INIT INFO

### ! The init info block above is not working correctly. ###

PATH="/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin"

[ -x /sbin/ifconfig ] || exit 0

me="fix-wlan0-hwaddr.sh"

case "$1" in
start)
	logger -s "[${me}] Overriding hardware address of wlan0 interface ..."
	WLAN0_HWADDR_FILE="/opt/extparam/mac_address_1"
	if [ -r "${WLAN0_HWADDR_FILE}" ]
	then
		WLAN0_HWADDR=$(cat "${WLAN0_HWADDR_FILE}")
		logger -s "[${me}] Trying to set the following hardware address. [${WLAN0_HWADDR}]"
		/sbin/ifconfig wlan0 hw ether ${WLAN0_HWADDR}
	else
		logger -s "[${me}] Failed to override hardware address. The extparam partition does not contain a hardware address for wlan0 interface."
	fi
        ;;

stop)
        ;;

*)
        echo "Usage: /etc/init.d/fix-wlan0-hwaddr.sh {start|stop}"
        exit 1
        ;;
esac

exit 0

