#!/bin/sh

me="[factory-reset.sh]"
echo "${me} Enter."

source /opt/gira/share/devicestack/ipmodule-vars

for reset_file in "${EMERGENCY_FACTORY_RESET_FILE}" "${FACTORY_RESET_FILE}"
do
	if [ -f "$reset_file" ]
	then
		# cat file and remove spaces, newlines, cariagereturns and tabs if any.
		FACTORY_RESET_CONDITION=`cat ${reset_file} | tr -d '\040\011\012\015'`
		if [ "enabled" = "${FACTORY_RESET_CONDITION}" ]
		then
			echo "${me} Factory reset found enabled. Cleaning userdata partition."
			echo "${me} Reformatting ${UD_BLOCKDEV}."
			/sbin/mkfs.ext3 ${UD_BLOCKDEV}
			sync
			echo "${me} Removing file: ${reset_file}"
			rm -f ${reset_file}
			echo "${me} Done."
			exit 0
		fi
	fi
done

echo "${me} Nothing to do."
exit 0

