#!/bin/sh
source "/opt/gira/bin/environment"

echo "called with "

if [[ $# -eq 0 ]] ; then
  LOGFILENAME="${GENLOGFILETMP}"/logfile.zip
else
  LOGFILENAME="$1"
fi

OVERWRITEZIP='minizip -o -1'
ADDTOZIP='minizip -a'
if [ -f /usr/bin/zip ]; then
  OVERWRITEZIP='zip -g'
  ADDTOZIP='zip -g'
fi

if [[ $# -eq 0 ]] ; then
# minizip cannot store folders and it seems to store only one folder level per command...
${OVERWRITEZIP} ${LOGFILENAME} ${DEFAULT_LOG_DIR}/*.* ${DEFAULT_LOG_DIR}/messages
fi
${ADDTOZIP} ${LOGFILENAME} ${DEFAULT_LOG_DIR}/samba/*
${ADDTOZIP} ${LOGFILENAME} ${PERSISTENT_LOG_DIR}/*
${ADDTOZIP} ${LOGFILENAME} /opt/userdata/knxdevice/* /opt/userdata/etc/iscapphost/iscapphostconfig.xml

ps w > /tmp/ps_w.txt
cd /tmp
${ADDTOZIP} ${LOGFILENAME} ps_w.txt
rm /tmp/ps_w.txt

ps l > /tmp/ps_l.txt
cd /tmp
${ADDTOZIP} ${LOGFILENAME} ps_l.txt
rm /tmp/ps_l.txt

dmesg > /tmp/dmesg.txt
cd /tmp
${ADDTOZIP} ${LOGFILENAME} dmesg.txt
rm /tmp/dmesg.txt

uptime > /tmp/uptime.txt
cd /tmp
${ADDTOZIP} ${LOGFILENAME} uptime.txt
rm /tmp/uptime.txt

df -h > /tmp/df.txt
cd /tmp
${ADDTOZIP} ${LOGFILENAME} df.txt
rm /tmp/df.txt
