#!/bin/sh

me="[factory-reset.sh]"
echo "${me} Enter."

start() {
  . /opt/gira/share/devicestack/ipmodule-vars
  for reset_file in "${EMERGENCY_FACTORY_RESET_FILE}" "${FACTORY_RESET_FILE}"
  do
	if [ -f "$reset_file" ]
	then
		# cat file and remove spaces, newlines, cariagereturns and tabs if any.
		FACTORY_RESET_CONDITION=$(tr -d '\040\011\012\015' < "${reset_file}")
		if [ "enabled" = "${FACTORY_RESET_CONDITION}" ]
		then
			echo "${me} Factory reset found enabled. Cleaning userdata partition."
			echo "${me} Reformatting ${UD_BLOCKDEV}."
			/sbin/mkfs.ext3 -F -E nodiscard -q "${UD_BLOCKDEV}"
			sync
			echo "${me} Removing file: ${reset_file}"
			rm -f "${reset_file}"
			echo "${me} Done."
			exit 0
		fi
	fi
  done

  echo "${me} Nothing to do."
}

case "$1" in
  start)
	start
	;;
  *)
	echo "Usage: $0 {start}, but makes no sense using this by hand."
	exit 1
esac

exit 0
