#!/bin/sh
#
# Script updates routes when called with a static ip configuration
#

# Determine currently active interface
IF="$(ip addr show | awk '/inet.*brd/{print $NF; exit}')"

# Source network info written by devicestack
. /opt/userdata/devicestack/network.conf

if [ "_${MODE}" = _STATIC ]
then
  # Set multicast route
  ip route replace 224.0.0.0/4 dev "$IF"
  # Replace default gateway
  ip route del default
  ip route add default via "$GATEWAY"
fi

if [ "$1" = "start" ]; then
  /opt/gira/bin/ds_notify_network.sh&
fi

exit 0
