#!/bin/sh
me="sync-wlan0-mac-address.sh"

logger -s "[${me}] Enter."

SETTINGS_BIN_FILE="/opt/extparam/GIG1LXKXIP_wlan0_settings.bin"
TEMP_SETTINGS_BIN_FILE="/tmp/settings.bin.temp"
MAC_ADDR_1_FILE="/opt/extparam/mac_address_1"
EXPECTED_MAC_ADDRESS_STRING_SIZE=17

if [ ! -r "${MAC_ADDR_1_FILE}" ]
then
  logger -s "[${me}] mac_address_1 file not readable. Abort!"
  exit 1
fi

MAC_ADDR_1=$(cat "${MAC_ADDR_1_FILE}" | tr -d '\040\011\012\015')

if [ ${#MAC_ADDR_1} -ne ${EXPECTED_MAC_ADDRESS_STRING_SIZE} ]
then
  logger -s "[${me}] ${MAC_ADDR_1_FILE} has unexpected content. Abort!"
  exit 1
fi

hexToDec()
{
  local nibble=$1
  local value=0
  case ${nibble} in
    0)
      value=0
      ;;
    1)
      value=1
      ;;
    2)
      value=2
      ;;
    3)
      value=3
      ;;
    4)
      value=4
      ;;
    5)
      value=5
      ;;
    6)
      value=6
      ;;
    7)
      value=7
      ;;
    8)
      value=8
      ;;
    9)
      value=9
      ;;
    A)
      value=10
      ;;
    B)
      value=11
      ;;
    C)
      value=12
      ;;
    D)
      value=13
      ;;
    E)
      value=14
      ;;
    F)
      value=15
      ;;
    *)
      logger -s "[${me}] Unallowed sign: '${nibble}' in ${MAC_ADDR_1_FILE}. Abort."
      exit 1
      ;;
  esac
  
  echo ${value}
}

rm -f ${TEMP_SETTINGS_BIN_FILE}
# Remove all colons from string.
MAC_STRING=$(echo ${MAC_ADDR_1//:/})
# echo "[${me}] Removed colons: ${MAC_STRING}"

counter=0
while [ ${counter} -lt 12 ]
do
  byte=0
  for nibble in `seq 1 2`
  do
    value=$(hexToDec ${MAC_STRING:${counter}:1})
    if [ ${nibble} -eq 1 ]
    then
      byte=$(( ${value} * 16 ))
    else
      byte=$(( ${byte} + ${value} ))
    fi
    counter=$(( ${counter} + 1 ))
  done
  echo -n -e \\x$(printf %x ${byte}) >> ${TEMP_SETTINGS_BIN_FILE}
done

if [ -f "${SETTINGS_BIN_FILE}" ]
then
  # Check if we correspond to value stored in MAC_ADDR_1_FILE
  cmp -s "${SETTINGS_BIN_FILE}" "${TEMP_SETTINGS_BIN_FILE}"
  if [ $? -eq 1 ]
  then
    logger -s "[${me}] MAC adresses from ${SETTINGS_BIN_FILE} and ${TEMP_SETTINGS_BIN_FILE} differ!"
    logger -s "[${me}] ${SETTINGS_BIN_FILE} will be replaced!"
    cp "${TEMP_SETTINGS_BIN_FILE}" "${SETTINGS_BIN_FILE}"
  else
    logger -s "[${me}] ${SETTINGS_BIN_FILE} is valid."
  fi
else
  # Create it if possible.
  logger -s "[${me}] ${SETTINGS_BIN_FILE} not found. Will create it."
  cp "${TEMP_SETTINGS_BIN_FILE}" "${SETTINGS_BIN_FILE}"
fi

logger -s "[${me}] Exit."

exit 0

