#!/bin/sh
#
# The factory reset will be handled exclusively on the Linux platform. This
# script only exists so no mkfs is called on a mounted device, and to enable
# an emergency factory reset via sdcard.
#

me="[factory-reset.sh]"
echo "${me} Enter."

start() {
  . /opt/gira/share/devicestack/ipmodule-vars
  if [ -f "${EMERGENCY_FACTORY_RESET_FILE}" ]
  then
    # remove any spaces, newlines, carriage returns and tabs from file content
    FACTORY_RESET_CONDITION=$(tr -d '\040\011\012\015' < "${EMERGENCY_FACTORY_RESET_FILE}")
    if [ "enabled" = "${FACTORY_RESET_CONDITION}" ]
    then
      echo "{me} Emergency factory reset found enabled. Rebooting into Linux..."
      set-platform linux
      reboot -d 0 -f
    fi
  fi
}

case "$1" in
  start)
        start
        ;;
  *)
        echo "Usage: $0 {start}, but makes no sense using this by hand."
        exit 1
esac

echo "${me} Exit."

exit 0
