#!/bin/sh

echo "[extparam.sh] Enter."

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

# This is meant as workaround for the yocto sd-card image.
# Should be removed as soon as it is not used anymore.
if ! [ -f /opt/gira/etc/devicestack/device.config ] && [ -f /opt/gira/etc/devicestack/emulation.config ]
then
  if ! [ -f "${COMMISSIONED_FILE}" ]
  then
    touch "${COMMISSIONED_FILE}"
  fi
fi

case "$1" in
  start)
    # We use the existence of /init to distinguish a CommissioningPackage
    # from a regular DevicePackage.
    # Our existing G1 CommissioningPackages have /init, while it doesn't
    # exist on regular DevicePackages.
    # TODO: Consider this fact or adapt this passage when creating new
    #       CommissioningPackage builds!
    if ! [ -f /init ]
    then
      BOOTED_SYSTEM=$(fw_printenv -n bootsystem)
      echo "${BOOTED_SYSTEM}" > "${BOOTED_SYSTEM_FILE}"
      if [ "${BOOTED_SYSTEM}" = "A" ]
      then
        OFFLINE_SYSTEM="B"
      else
        OFFLINE_SYSTEM="A"
      fi
      echo "${OFFLINE_SYSTEM}" > /var/run/offline_system
      BOOTED_PLATFORM=$(fw_printenv -n platform)
      BOOTED_PLATFORM=${BOOTED_PLATFORM:-android}
      echo "${BOOTED_PLATFORM}" > /var/run/booted_platform
    else
      BOOTED_SYSTEM="A"
      echo "A" > "${BOOTED_SYSTEM_FILE}"
      OFFLINE_SYSTEM="B"
      echo "B" > /var/run/offline_system
    fi

    cd /var/run
    ln -sf "${EXTPARAM}/system_${BOOTED_SYSTEM}_firmware_version" booted_firmware_version
    ln -sf "${EXTPARAM}/system_${BOOTED_SYSTEM}_application_version" booted_application_version
    ln -sf "${EXTPARAM}/system_${BOOTED_SYSTEM}_system_version" booted_system_version
    ln -sf "${EXTPARAM}/system_${BOOTED_SYSTEM}_root_blkdev" booted_root_blkdev
    ln -sf "${EXTPARAM}/system_${BOOTED_SYSTEM}_kernel_blkdev" booted_kernel_blkdev
    ln -sf "system_${BOOTED_SYSTEM}_boot_counter" booted_boot_counter
    ln -sf "${EXTPARAM}/system_${OFFLINE_SYSTEM}_firmware_version" offline_firmware_version
    ln -sf "${EXTPARAM}/system_${OFFLINE_SYSTEM}_application_version" offline_application_version
    ln -sf "${EXTPARAM}/system_${OFFLINE_SYSTEM}_system_version" offline_system_version
    ln -sf "${EXTPARAM}/system_${OFFLINE_SYSTEM}_root_blkdev" offline_root_blkdev
    ln -sf "${EXTPARAM}/system_${OFFLINE_SYSTEM}_kernel_blkdev" offline_kernel_blkdev
    ln -sf "system_${OFFLINE_SYSTEM}_boot_counter" offline_boot_counter

    cd "${EXTPARAM}"
    [ -h booted_application_version ] || ln -sf /var/run/booted_application_version
    [ -h booted_system_version ] || ln -sf /var/run/booted_system_version
    [ -h booted_firmware_version ] || ln -sf /var/run/booted_firmware_version
    [ -h booted_boot_counter ] || ln -sf /var/run/booted_boot_counter
    [ -h booted_root_blkdev ] || ln -sf /var/run/booted_root_blkdev
    [ -h booted_system ] || ln -sf "${BOOTED_SYSTEM_FILE}"
    [ -h booted_platform ] || ln -sf /var/run/booted_platform
    [ -h offline_application_version ] || ln -sf /var/run/offline_application_version
    [ -h offline_system_version ] || ln -sf /var/run/offline_system_version
    [ -h offline_firmware_version ] || ln -sf /var/run/offline_firmware_version
    [ -h offline_boot_counter ] || ln -sf /var/run/offline_boot_counter
    [ -h offline_root_blkdev ] || ln -sf /var/run/offline_root_blkdev
    [ -h offline_system ] || ln -sf /var/run/offline_system
    [ -h system_A_boot_counter ] || ln -sf /var/run/system_A_boot_counter
    [ -h system_B_boot_counter ] || ln -sf /var/run/system_B_boot_counter

    # Read boot counter.
    fw_printenv -n bcA > /var/run/system_A_boot_counter
    fw_printenv -n bcB > /var/run/system_B_boot_counter

    MANUFACTURER_ID=""
    [ -f "${EXTPARAM}/manufacturer_id" ] && MANUFACTURER_ID=$(cat "${EXTPARAM}/manufacturer_id")

    DEVICE_ID=""
    [ -f "${EXTPARAM}/device_id" ] && DEVICE_ID=$(cat "${EXTPARAM}/device_id")

    if [ -f "${EXTPARAM}/mac_address_0" ]
    then
      MAC0_WITHOUT_COLONS=$(head -n 1 /opt/extparam/mac_address_0 | tr -d ':' | tr '[:lower:]' '[:upper:]')
      LAST_SIX_OF_MAC0=$(echo "${MAC0_WITHOUT_COLONS}" | cut -c7-12)
      SN="${MANUFACTURER_ID}${DEVICE_ID}${LAST_SIX_OF_MAC0}"
      if [ -f "${EXTPARAM}/serial_number" ]
      then
        SN_EXT=$(head -n 1 "${EXTPARAM}/serial_number")
        if [ "${SN}" = "${SN_EXT}" ]
        then
          echo "[extparam.sh] serial_number is OK."
        else
          echo "[extparam.sh] serial_number is not OK. Will now update serial_number file."
          echo "${SN}" > "${EXTPARAM}/serial_number"
        fi
      else
        echo "[extparam.sh] serial_number is not OK. Will now create serial_number file."
        echo "${SN}" > "${EXTPARAM}/serial_number"
      fi
    else
      echo "[extparam.sh] serial_number is missing, but this is OK, if the device is not yet commissioned."
    fi
    
    if [ -e "${GIRA_BIN}/sync-eth0-mac-address.sh" ]
    then
      "${GIRA_BIN}/sync-eth0-mac-address.sh"
    fi
    if [ -e "${GIRA_BIN}/sync-uid.sh" ]
    then
      "${GIRA_BIN}/sync-uid.sh"
    fi
    if [ -e "${GIRA_BIN}/sync-wlan0-mac-address.sh" ]
    then
      "${GIRA_BIN}/sync-wlan0-mac-address.sh"
    fi
    # If ssl_cert exists, extract the device.crt and device.key from it that are required by nginx config.
    if [ -e "${EXTPARAM}/ssl_cert" ]; then
      echo -n "${me} Does device certificate file exist? ... "
      if [ ! -e "${EXTPARAM}/device.crt" ]; then
        echo "no. We need to create it now."
        openssl pkcs12 -in "${EXTPARAM}/ssl_cert" -out "${EXTPARAM}/device.crt" -clcerts -nokeys -passin 'pass:'
      else
        echo "yes."
      fi
      echo -n "${me} Does device key file exist? ... "
      if [ ! -e "${EXTPARAM}/device.key" ]; then
        echo "no. We need to create it now."
        openssl pkcs12 -in "${EXTPARAM}/ssl_cert" -out "${EXTPARAM}/device.key" -nocerts -nodes -passin 'pass:'
      else
        echo "yes."
      fi
    else
      echo "${me} The device pkcs12 in ${EXTPARAM}/ssl_cert does not exist. Therefore we cannot create the crt and key file for nginx."
    fi
    sync
    ;;
  stop)
    ;;
  *)
    echo "Usage: $0 (start|stop)"
    exit 1
esac

echo "[extparam.sh] Exit."

exit 0
