#!/system/bin/sh
#
# Copy template apps from default dir to app target location.
# This will only be done once after an update, and only for apps that
# don't yet exist there.
#

if ! [ -f /data/app/.templates-copied ]
then
  for app in gira/opt/gira/default/apps/*
  do
    basename=$(busybox basename "${app}")
    if ! [ -e "/data/app/${basename}" ]
    then
      busybox install -m 755 "${app}" /data/app/
    fi
  done

  touch /data/app/.templates-copied
fi
