#!/bin/sh

[ -f "/sys/class/rtc/rtc0/device/driver/0-0068/name" ] || exit 0

start() {
  echo 0-0068 > /sys/bus/i2c/drivers/rtc-rv8523/unbind

  reg=$(i2cget -y 0 0x68 0x02)
  if [ "$reg" != "0x00" ]; then
    i2cset -y 0 0x68 0x02 0x00
    logger -s "warning: hwclock restored after power outage: $reg"
  fi

  echo 0-0068 > /sys/bus/i2c/drivers/rtc-rv8523/bind
}

case "$1" in
  start)
    start
    ;;
  *)
    echo "Usage: /etc/init.d/hwclock-power.sh start"
    ;;
esac

exit 0
