#!/bin/sh
#
# If device was updated from a version smaller than 3.1 to 3.1 then
# reenable tks_ip_gw_proxy by creating the enable file

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

case "$1" in
  start)
    ENABLE_FILE="/opt/userdata/tks_ip_gw_proxy.enabled"
    BOOTED_FILE="${EXTPARAM}/booted_firmware_version"
    OFFLINE_FILE="${EXTPARAM}/offline_firmware_version"
    if [ ! -e "$ENABLE_FILE" ] && \
        [ -e "$BOOTED_FILE" -a -e "$OFFLINE_FILE" ]; then
      BOOTED_VERSION=$(cat "$BOOTED_FILE")
      OFFLINE_VERSION=$(cat "$OFFLINE_FILE")
      if [ ! -z "$OFFLINE_VERSION" -a "0.0.0.0" != "$OFFLINE_VERSION" -a "$BOOTED_VERSION" != "$OFFLINE_VERSION" ]; then
        OFFLINE_VERSION_MAJOR=$(echo "$OFFLINE_VERSION" | cut -d . -f1)
        OFFLINE_VERSION_MINOR=$(echo "$OFFLINE_VERSION" | cut -d . -f2)
        if [ "$OFFLINE_VERSION_MAJOR" -lt 3 ] \
            || [ "$OFFLINE_VERSION_MAJOR" -eq 3 -a "$OFFLINE_VERSION_MINOR" -lt 1 ]; then
          echo "Enabling tks_ip_gw_proxy after update from $OFFLINE_VERSION to $BOOTED_VERSION"
          touch "$ENABLE_FILE"
        fi
      fi
    fi
    ;;
  *)
    echo "Usage: $0 (start)"
    exit 1
esac

exit 0
