#!/system/bin/sh

me=start-gds.sh
log -p v -t "$me" "Enter"

# Adding symlink for changeroot bash to work properly, if it doesn't exist yet.
# The 'userdata-restore.sh' script makes use of a feature called “process
# substitution”, which needs '/dev/fd' to work properly.
# Read here for more info: http://tldp.org/LDP/abs/html/process-sub.html
[[ ! -L /dev/fd ]] && ln -s /proc/self/fd /dev/fd

echo "Starting Gira Devicestack..."

# Mount stuff for chroot. Note that the Android "mount" does not support the "--bind" option, which is needed for mounting "/dev".
busybox mount --rbind /dev /gira/dev
busybox mount --rbind /sys /gira/sys
busybox mount -t proc /proc /gira/proc
# Create and bind mount shm directory for VPU
mkdir -p /gira/dev/shm
mount -o bind /mnt/shm/ /gira/dev/shm/

# Manually add IP address when configured statically. Although initialised with
# this IP in the EthernetNetworkFactory, it somewhere got lost. This is an ugly
# workaround for a quick result.
if [ "$(getprop persist.net.eth0.mode)" = "manual" ]
then
  ip addr add "$(getprop persist.net.eth0.ip)/$(getprop persist.net.eth0.mask)" dev eth0
fi
# Enable forwarding so ethernet is available in chroot
busybox sysctl -w net.ipv4.ip_forward=1

log -p v -t "$me" "Start chroot environment"
# Use Yocto busybox to changeroot. Android does not come with the "chroot" command by default.
. /vendor/chroot-env
busybox chroot /gira /usr/bin/env -i $ENVIRONMENT /init.sh
