#!/system/bin/sh
#
# This script makes the device reboot after a number of zygote restarts.
#

ZYGOTE_RESTARTS=$(getprop sys.zygote.restarts)
ZYGOTE_RESTARTS=${ZYGOTE_RESTARTS:-0}
ZYGOTE_RESTARTS=$((ZYGOTE_RESTARTS+1))
setprop sys.zygote.restarts ${ZYGOTE_RESTARTS}

# When killing the zygote from commandline, this counter is increased by two.
# I don't know if that's always the case, but given that fact I think '5' is an
# acceptable value here before invalidating the booted system.
if ((ZYGOTE_RESTARTS>5))
then
  BOOTED_SYSTEM=$(cat /gira/run/booted_system)
  # If we don't know which system is booted, this would be pretty pointless.
  if test "$BOOTED_SYSTEM" = 'A' || test "$BOOTED_SYSTEM" = 'B'
  then
    echo 3 > "/gira/run/system_${BOOTED_SYSTEM}_boot_counter"
    /vendor/bin/gds-reboot.sh
  fi
fi
