#!/system/bin/sh

if ! grep "/dev/block/mmcblk0p4 /gira/opt/userdata ext3 rw" < /proc/mounts
then
  log Userdata partition is not mounted!

  # Try to repair filesystem
  log Attempting automatic filesystem repair on userdata...
  e2fsck -y /dev/block/mmcblk0p4
  if [ $? -le 2 ]
  then
    log Repair successful, rebooting!
    reboot
    exit 0
  fi

  log Repair failed, executing a factory reset as last resort!
  echo enabled > /gira/opt/extparam/factory_reset_condition
  busybox mount --rbind /dev /gira/dev
  . /vendor/chroot-env
  busybox chroot /gira /usr/bin/env -i $ENVIRONMENT /opt/gira/bin/set-platform linux
  reboot
fi
