#!/bin/sh
#
# This script only checks if the userdata partition has been mounted by the
# Android fstab. If not, a factory reset will be triggered.
#

me="[userdata.sh]"

echo "${me} Enter."

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

case "$1" in
  start)
    echo -n "${me} Checking userdata fs ... "
    if [ ! -f "${UD_MOUNTED_FILE}" ]
    then
      if [ ! "$(cat /proc/mounts | grep "${MP_USERDATA}")"  = "" ]
      then
        echo "mounted"
        echo "${me} Updating mount info."
        touch "${UD_MOUNTED_FILE}"
        echo "${me} Creating FWU directory."
        mkdir -p "${UD_FWU_DIR}"
        logger -t "${me} userdata.initd" -s "Creating directories..."
        mkdir -p "${MP_USERDATA}/knxstack"
      else
        echo "failed."
        echo "Executing factory reset."
        echo "enabled" > "${FACTORY_RESET_FILE}"
        echo "Rebooting NOW!"
        ${REBOOT}
      fi
    else
      echo "skipped (already mounted)."
    fi
    ;;
  stop)
    # Nothing to do here, the Android system should take care of it
    ;;
  *)
    echo "Usage: $0 (start|stop)"
    exit 1
esac

echo "${me} Exit."

exit 0
