#!/bin/bash
# This script mounts the sdcard on startup, if available.

me="[sdcard]"

MOUNT="/bin/mount"

MOUNTPOINT="/opt/card"
DEVNAME="/dev/mmcblk1p1"

# Check if block device for sdcard is present
if ! [ -b ${DEVNAME} ]
then
  echo "No sdcard present, skipping"
  exit 0
fi

# Check if the passed device is blacklisted
for line in $(grep -v ^# /etc/udev/mount.blacklist)
do
  if [ "$(expr match "${DEVNAME}" "$line")" -gt 0 ]
  then
    echo "${me} ${DEVNAME} is blacklisted in udev, ignoring"
    exit 0
  fi
done

# Try to mount the sdcard and just assume it is type vfat
echo "${me} Try mounting ${DEVNAME} to ${MOUNTPOINT} ... "
${MOUNT} -t vfat -o rw,suid,sync,noatime ${DEVNAME} ${MOUNTPOINT}
if [ $? -eq 0 ]
then
  echo "${me} done."
else
  echo "${me} failed!"
fi

exit 0
