'use strict';

export interface IDisposable {
    dispose(): void;
}

export function isDisposable<E extends object>(obj: E): obj is E & IDisposable {
    return typeof (<IDisposable><any>obj).dispose === 'function' && (<IDisposable><any>obj).dispose.length === 0;
}