local json = require("json")

function GetVersion()
  return 1
end

function GetCommands()
  return json.encode(
    {
      {
        type = "api",
        data = json.encode({command = "getdeviceconfig", ipc = true}),
        func = "HandleGetDeviceConfig"
      }
    }
  )
end

function HandleGetDeviceConfig(response)
  local j = json.decode(response)
  local devcfg = GetFromTable(j, "response", "deviceConfig", "ipc")
  if devcfg
  then
    local fwv = GetFromTable(devcfg, "CurrentFirmwareVersion")
    local manu = GetFromTable(devcfg, "ManufacturerId")
    local device = GetFromTable(devcfg, "DeviceId")
    return json.encode({firmwareVersion = fwv, model = (manu .. device)})
  end

  return ""
end

function GetFromTable(tbl, key, ...)
  return not key and tbl or tbl[key] and GetFromTable(tbl[key], ...)
end
