#!/bin/sh

echo ""
echo "=== Begin of system information block ==="

# get eth0 information
set -- $(ifconfig eth0 | grep "HWaddr")
ETH0_HWADDR="$5"
set -- $(ifconfig eth0 | grep "inet addr")
ETH0_IPADDR=$(echo "$2" | cut -d':' -f2)
ETH0_NETMASK=$(echo "$4" | cut -d':' -f2)

# get wlan0 information
set -- $(ifconfig wlan0 | grep "HWaddr")
WLAN0_HWADDR="$5"
set -- $(ifconfig wlan0 | grep "inet addr")
WLAN0_IPADDR=$(echo "$2" | cut -d':' -f2)
WLAN0_NETMASK=$(echo "$4" | cut -d':' -f2)

[ -r "/opt/extparam/ipmodule_id" ]                  && echo "ipmodule_id                  : $(cat /opt/extparam/ipmodule_id)"
[ -r "/opt/extparam/ipmodule_version" ]             && echo "ipmodule_version             : $(cat /opt/extparam/ipmodule_version)"
[ -r "/opt/extparam/ipmodule_revision" ]            && echo "ipmodule_revision            : $(cat /opt/extparam/ipmodule_revision)"
[ -r "/opt/extparam/extmodule_id" ]                 && echo "extmodule_id                 : $(cat /opt/extparam/extmodule_id)"
[ -r "/opt/extparam/extmodule_version" ]            && echo "extmodule_version            : $(cat /opt/extparam/extmodule_version)"
[ -r "/opt/extparam/extmodule_revision" ]           && echo "extmodule_revision           : $(cat /opt/extparam/extmodule_revision)"
[ -r "/opt/extparam/manufacturer_id" ]              && echo "manufacturer_id              : $(cat /opt/extparam/manufacturer_id)"
[ -r "/opt/extparam/device_id" ]                    && echo "device_id                    : $(cat /opt/extparam/device_id)"
[ -r "/opt/extparam/device_uid" ]                   && echo "device_uid                   : $(cat /opt/extparam/device_uid)"
[ -r "/opt/extparam/device_guid" ]                  && echo "device_guid                  : $(cat /opt/extparam/device_guid)"
[ -r "/opt/extparam/device_version" ]               && echo "device_version               : $(cat /opt/extparam/device_version)"
[ -r "/opt/extparam/serial_number" ]                && echo "serial_number                : $(cat /opt/extparam/serial_number)"
[ -r "/opt/extparam/hostname" ]                     && echo "hostname                     : $(cat /opt/extparam/hostname)"
[ -r "/opt/extparam/knx_serialnumber_0" ]           && echo "knx_serialnumber_0           : $(cat /opt/extparam/knx_serialnumber_0)"
[ -r "/opt/extparam/knx_serialnumber_1" ]           && echo "knx_serialnumber_1           : $(cat /opt/extparam/knx_serialnumber_1)"
[ -r "/opt/extparam/knx_serialnumber_2" ]           && echo "knx_serialnumber_2           : $(cat /opt/extparam/knx_serialnumber_2)"
[ -r "/opt/extparam/knx_serialnumber_3" ]           && echo "knx_serialnumber_3           : $(cat /opt/extparam/knx_serialnumber_3)"
[ -r "/opt/extparam/mac_address_0" ]                && echo "mac_address_0                : $(cat /opt/extparam/mac_address_0)"
[ -r "/opt/extparam/mac_address_1" ]                && echo "mac_address_1                : $(cat /opt/extparam/mac_address_1)"
[ -r "/opt/extparam/mac_address_2" ]                && echo "mac_address_2                : $(cat /opt/extparam/mac_address_2)"
[ -r "/opt/extparam/mac_address_3" ]                && echo "mac_address_3                : $(cat /opt/extparam/mac_address_3)"
[ -r "/opt/extparam/supported_systems" ]            && echo "supported_systems            : $(cat /opt/extparam/supported_systems)"
[ -r "/opt/extparam/booted_system" ]                && echo "booted_system                : $(cat /opt/extparam/booted_system)"
[ -r "/opt/extparam/offline_system" ]               && echo "offline_system               : $(cat /opt/extparam/offline_system)"
[ -r "/opt/extparam/system_A_application_version" ] && echo "system_A_application_version : $(cat /opt/extparam/system_A_application_version)"
[ -r "/opt/extparam/system_A_boot_counter" ]        && echo "system_A_boot_counter        : $(cat /opt/extparam/system_A_boot_counter)"
[ -r "/opt/extparam/system_A_firmware_version" ]    && echo "system_A_firmware_version    : $(cat /opt/extparam/system_A_firmware_version)"
[ -r "/opt/extparam/system_A_root_blkdev" ]         && echo "system_A_root_blkdev         : $(cat /opt/extparam/system_A_root_blkdev)"
[ -r "/opt/extparam/system_A_system_version" ]      && echo "system_A_system_version      : $(cat /opt/extparam/system_A_system_version)"
[ -r "/opt/extparam/system_B_application_version" ] && echo "system_B_application_version : $(cat /opt/extparam/system_B_application_version)"
[ -r "/opt/extparam/system_B_boot_counter" ]        && echo "system_B_boot_counter        : $(cat /opt/extparam/system_B_boot_counter)"
[ -r "/opt/extparam/system_B_firmware_version" ]    && echo "system_B_firmware_version    : $(cat /opt/extparam/system_B_firmware_version)"
[ -r "/opt/extparam/system_B_root_blkdev" ]         && echo "system_B_root_blkdev         : $(cat /opt/extparam/system_B_root_blkdev)"
[ -r "/opt/extparam/system_B_system_version" ]      && echo "system_B_system_version      : $(cat /opt/extparam/system_B_system_version)"
[ -r "/opt/extparam/userdata_root_blkdev" ]         && echo "userdata_root_blkdev         : $(cat /opt/extparam/userdata_root_blkdev)"
[ -r "/opt/extparam/bootloader_version" ]           && echo "bootloader_version           : $(cat /opt/extparam/bootloader_version)"
[ -r "/opt/extparam/bootscript_version" ]           && echo "bootscript_version           : $(cat /opt/extparam/bootscript_version)"
[ -r "/opt/extparam/bootstrap_version" ]            && echo "bootstrap_version            : $(cat /opt/extparam/bootstrap_version)"
                                                       echo "eth0_hwaddr                  : ${ETH0_HWADDR}"
                                                       echo "eth0_ipaddr                  : ${ETH0_IPADDR}"
                                                       echo "eth0_netmask                 : ${ETH0_NETMASK}"
                                                       echo "wlan0_hwaddr                 : ${WLAN0_HWADDR}"
                                                       echo "wlan0_ipaddr                 : ${WLAN0_IPADDR}"
                                                       echo "wlan0_netmask                : ${WLAN0_NETMASK}"
[ -r "/sys/bus/mmc/devices/mmc0:0001/name" ]        && echo "mmc0_name                    : $(cat /sys/bus/mmc/devices/mmc0:0001/name)"
echo "=== End of system information block   ==="
echo ""
