#!/system/bin/sh
#
# This script starts the wpa_supplicant with the given parameters and then
# enters a loop to monitor updates to the system properties set by the
# WifiService. If changes are detected, they are sent to the devicestack
# via API.
#
# This script is meant to be a a dropin for the wpa_supplicant services as they
# are defined in /init.freescale.rc.
#

# Start wpa_supplicant as the service would
/system/bin/wpa_supplicant "$@" &

sleep 5

# Loop while wifi is enabled
while [ -d /sys/class/net/wlan0 ]
do
  if [ -z "$(getprop wifi.wlan0.ipv4.addr)" ]
  then
    # Wifi configuration is DHCP
    if [ "$MODE" != "DHCP" ]
    then
      dscsampleapp -r="{\"command\":\"SetDeviceConfig\",\"deviceConfig\":{\"Dhcp\":true}}"
      MODE=DHCP
      GW=
      IP=
      MASK=
      DNS1=
      DNS2=
    fi
  else
    # Wifi configuration is static
    if [ "$MODE" != "STATIC" ] \
      || [ "$IP" != "$(getprop wifi.wlan0.ipv4.addr)" ] \
      || [ "$MASK" != "$(getprop wifi.wlan0.ipv4.netmask)" ] \
      || [ "$GW" != "$(getprop wifi.wlan0.gateway)" ] \
      || [ "$DNS1" != "$(getprop wifi.wlan0.dns1)" ] \
      || [ "$DNS2" != "$(getprop wifi.wlan0.dns2)" ]
    then
      MODE=STATIC
      IP="$(getprop wifi.wlan0.ipv4.addr)"
      MASK="$(getprop wifi.wlan0.ipv4.netmask)"
      GW="$(getprop wifi.wlan0.gateway)"
      DNS1="$(getprop wifi.wlan0.dns1)"
      DNS2="$(getprop wifi.wlan0.dns2)"

      . /vendor/chroot-env
      busybox chroot /gira /usr/bin/env -i $ENVIRONMENT /opt/gira/bin/dscsampleapp \
        -r="{\"command\":\"SetDeviceConfig\",\"deviceConfig\":{\"Dhcp\":false,\
        \"IpAddress\":\"$IP\",\"DefaultGateway\":\"$GW\",\"SubnetMask\":\"$MASK\",
        \"NameServer\":\"$DNS1\",\"NameServer2\":\"$DNS2\"}}"
    fi
  fi
  sleep 10
done
