#!/system/bin/sh
#
# This script (re)configures additional routes required for the devicestack to
# reach the network. It doesn't just use what’s there, it explicitly reads from
# /proc/net/route0.

# Get currently used network interface
ipaddr=$(ip addr show | busybox awk '/inet.*brd/')
intf=${ipaddr##* }
[ -z ${intf} ] && intf=none
setprop net.interface ${intf}

# Add default gateway
gw=$(getprop dhcp.${intf}.gateway)
ip route replace default via "${gw}" dev ${intf}

# Reconfigure multicast route
ip route replace 224.0.0.0/4 dev ${intf}
