#!/system/bin/sh
#
# This script reads the configuration set in the wizard and sets it in the
# Android system once (triggers again after factory reset).

stamp_file=/gira/opt/userdata/.configured-from-wizard

if ! [ -f "$stamp_file" ]
then
  lang_file=/gira/opt/userdata/devicestack/appData/confd/GeneratorConfiguration
  timezone_file=/gira/opt/userdata/devicestack/timezone

  if [ -f "$lang_file" ]
  then
    lang=$(cut -d '"' -f4 < "$lang_file")
    setprop persist.sys.language "$lang"
  fi

  if [ -L "$timezone_file" ]
  then
    tz=$(readlink "$timezone_file" | busybox sed -e "s/\/usr\/share\/zoneinfo\///")
    setprop persist.sys.timezone "$tz"
  fi

  touch "$stamp_file"
fi
