#!/bin/sh
#
# Reboot script called by GDS.
# - writes values from files in EXTPARAM to UBoot environment variables.
# - sets UBoot environment variable is_reboot to 1 (one) to let UBoot know
#   it's a GDS requested reboot thus leaving bootcounters untouched.
#

source /opt/gira/share/devicestack/ipmodule-vars

me="gds-reboot.sh"

CALLER=$(ps | grep "^ *$PPID" | awk '{print $NF}')
logger -s "[$me] Called by: ${CALLER}"

logger -s "[$me] Synchronizing settings before restart."

${ENVIRONMENT_SYNC_SCRIPT}

logger -s "[$me] Settings is_reboot to 1."
fw_setenv is_reboot 1

logger -s "[$me] Calling init scripts with “stop” for proper shutdown."
# Nobody else takes care of this (no busybox or Android init/reboot), so we call
# them ourselves.
/etc/init.d/S90devicestack stop
/etc/init.d/S50sshd stop
/etc/init.d/S40network stop
/etc/init.d/S12userdata.sh stop

# Actually reboot.
logger -s "[$me] Calling system reboot!"
${REBOOT} -d 0 -f

exit 0
