/*global ko, isNumeric*/
/*jslint browser: true*/
(function (ns) {
    "use strict";

    function SvgKnobPath(radius, lineWidth, width) {
        var maxValue = 100,
            strokeColorBack = '#f2f2f2',
            strokeColorFront = '#ff8000',
            strokeWidth = lineWidth,
            dashArray = 2 * radius * Math.PI,
            solidPath = ko.observable("M 320 165 A 155 155 0 0 0 320 165"), // 0
            dottedPath = ko.observable("M 320 165 A 155 155 0 0 0 320 165"), // 0
            size = width,
            center = width / 2,
            isValidValue = window.Gira.Globals.isValidValue,
            globals = window.Gira.Globals,
            id = globals.createGUID(),//usedForStyling,
            gradientRingId ="gr" + id,
            delay = 1000 / 60;

        function polarToCartesian(centerX, centerY, radius, angleInDegrees) {
            var angleInRadians = (angleInDegrees - 90) * Math.PI / 180.0;

            return {
                x: centerX + (radius * Math.cos(angleInRadians)),
                y: centerY + (radius * Math.sin(angleInRadians))
            };
        }

        function describeArc(x, y, radius, startAngle, endAngle){

            var start = polarToCartesian(x, y, radius, endAngle);
            var end = polarToCartesian(x, y, radius, startAngle);

            var largeArcFlag = endAngle - startAngle <= 180 ? "0" : "1";

            var d = [
                "M", start.x, start.y,
                "A", radius, radius, 0, largeArcFlag, 0, end.x, end.y
            ].join(" ");

            return d;
        }

        function withDelay(callback) {
            setTimeout(callback, delay);
        }

        function calcDashOffsetFront(fromValue, toValue) {
            var angleFrom = (fromValue * 3.6),
                angleTo = (toValue === 100) ? (99.999 * 3.6) : (toValue * 3.6),
                pathFrom = describeArc(center, center, radius, 0, angleFrom),
                pathTo = describeArc(center, center, radius, 0, angleTo);

            if (!isValidValue(fromValue) || !isValidValue(toValue)) {
                return;
            }

            if (toValue === fromValue) {
                withDelay(function () {
                    solidPath(pathTo);
                    dottedPath(pathTo);
                });
            } else {
                if (toValue < fromValue) {
                    if (solidPath() !== pathTo) {
                        solidPath(pathTo);
                    }
                    withDelay( function () {
                        dottedPath(pathFrom);
                    });
                } else {
                    if (dottedPath() !== pathTo) {
                        dottedPath(pathTo);
                    }
                    withDelay( function () {
                        solidPath(pathFrom);
                    });
                }
            }
        }

        return {
            arc: calcDashOffsetFront,
            center: center,
            radius: radius,
            strokeColorBack: strokeColorBack,
            strokeColorFront: strokeColorFront,
            strokeWidth: strokeWidth,
            dashArray: dashArray,
            solidPath : solidPath,
            dottedPath : dottedPath, // to do: add another dash offset
            size: size,
            gradientRingId: gradientRingId
        };
    }

    ns.SvgKnobPath = SvgKnobPath;
}(window.Gira));