/*global ko, isNumeric*/
/*jslint browser: true*/
(function (ns) {
    "use strict";

    function SvgKnob(radius, lineWidth, width, centerXY, minVal, maxVal, knobOptions) {
        var strokeColorBack = '#f2f2f2',
            strokeColorFront = '#ff8000',
            defaultDashStrokeRotation = - 90, //The start position for dashed strokes on a circle is the 90 degrees, we must rotate by -90 by default;
            svgRotationAngle = 360 - Math.abs(knobOptions.angleOffset + defaultDashStrokeRotation), // rotate svg circle path for given angle
            delay = 1000 / 60,
            dashArray = (2 * radius * Math.PI) + 2,
            globals = window.Gira.Globals,
            displayPrevious = knobOptions.displayPrevious || false,
            id = globals.createGUID(),//usedForStyling,
            gradientRingId ="gr" + id,
            isValidValue = globals.isValidValue,
            strokeWidth = lineWidth,
            dashOffsetFront = ko.observable(dashArray),
            dashOffsetBack = ko.observable(dashArray),
            size = width,
            center = centerXY,
            anglePercentage = (knobOptions.angleArc / 360) * 100,
            valueStepSize = anglePercentage / (maxVal - minVal),
            isVisible = (typeof knobOptions.draw === "function") ? knobOptions.draw() : true;

        function withDelay(callback) {
            setTimeout(callback, delay);
        }

        function setDashOffsets(fromValue, toValue, offsetFrom, offsetTo) {
            if (toValue === fromValue) {
                withDelay(function () {
                    //when is finished set front and stripped shape to same value
                    dashOffsetFront(offsetTo);
                    dashOffsetBack(offsetTo);
                });
            } else {
                if (toValue < fromValue) {
                    if (dashOffsetFront() !== offsetTo) {
                        dashOffsetFront(offsetTo);
                    }
                    //when starting value is bigger then destination value
                    //only stripped shape should be animated
                    withDelay(function () {
                        dashOffsetBack(offsetFrom);
                    });
                } else {
                    if (dashOffsetBack() !== offsetTo) {
                        dashOffsetBack(offsetTo);
                    }
                    //when starting value is less then destination value
                    //only front shape should be animated
                    withDelay(function () {
                        dashOffsetFront(offsetFrom);
                    });
                }
            }
        }

        function calcDashOffsetFront(fromValue, toValue) {
            var finalValue = toValue * valueStepSize,
                offsetFrom = dashArray * (1 - fromValue / 100),
                offsetTo = dashArray * (1 - finalValue / 100);

            if (!isValidValue(fromValue) && !isValidValue(toValue)) {
                return;
            }

            if (displayPrevious) {
                //set offsets for current and previous value based on from / to values
                setDashOffsets(fromValue, toValue, offsetFrom, offsetTo);
            } else {
                // draw only front shape
                withDelay(function () {
                    dashOffsetFront(offsetTo);
                });
            }
        }

        return {
            arc: calcDashOffsetFront,
            center: center,
            radius: radius,
            strokeColorBack: strokeColorBack,
            strokeColorFront: strokeColorFront,
            strokeWidth: strokeWidth,
            dashArray: dashArray,
            dashOffsetFront : dashOffsetFront,
            dashOffsetBack : dashOffsetBack, // to do: add another dash offset
            size: size,
            gradientRingId: gradientRingId,
            svgRotationAngle : svgRotationAngle,
            isVisible : isVisible
        };
    }
    ns.SvgKnob = SvgKnob;
}(window.Gira));