#!/bin/sh

# echo 0 if system is doing no copy operation
# echo ${percent} if system is cloning
# echo -${percent} if system is updating

get_used_size()
{
# $1 name
# $2 block
# $3 used
# $4 available
	echo "$3" 
}

df_root_raw="$(df | grep /dev/root )"
df_offline_raw="$(df | grep system_offline )"
df_current_raw="$(df | grep system_current )"

df_root="$( get_used_size $df_root_raw)"
df_offline="$( get_used_size $df_offline_raw)"
df_current="$( get_used_size $df_current_raw)"

if [ ! "${df_offline}" = "" ] && [ ! "${df_current}" = "" ]
then
	df_offline_100=$(( ${df_offline} * 100 ));
	status=$((  ${df_offline_100} / ${df_current} ))
	echo "$status"
	exit 0
fi

if [ ! "${df_offline}" = "" ] && [ "${df_current}" = "" ] && [ ! "${df_root}" = "" ]
then
	df_offline_100=$(( ${df_offline} * 100 ));
	status=$((  ${df_offline_100} / ${df_root} ))
	echo "-$status"
	exit 0
fi

echo 0
exit 0
