#!/bin/bash

DEFAULT_DIR="/opt/gira/default/userdata"
USERDATA_DIR="/opt/userdata"

# In conjunction with the factory reset the timeout time of 60s might not
# be enough. Triggering on start) entry and exit gives 60s of time for copying
# stuff to userdata wich should be sufficient and restricts the module to only bark
# two times.
case "$1" in
  start)
    echo Z > /dev/watchdog
    cd ${DEFAULT_DIR}
    # Create directories that exist in template directory
    find -type d -exec mkdir -p "${USERDATA_DIR}/{}" \;
    # Copy regular template files
    FILES=$(find -type f | tr '\n' ' ')
    for file in ${FILES}
    do
      if [ ! -f "${USERDATA_DIR}/$file" ]
      then
        cp -p "${DEFAULT_DIR}/$file" "${USERDATA_DIR}/$file"
      fi
    done
    # Copy template symlinks, too
    LINKS=$(find -type l | tr '\n' ' ')
    for link in ${LINKS}
    do
     if [ ! -e "${USERDATA_DIR}/$link" ]
     then
       cp -pP "${DEFAULT_DIR}/$link" "${USERDATA_DIR}/$link"
      fi
    done
    # Overwrite platform-specific configuration files if they differ
    PLATFORM_SPECIFIC_FILES="devicestack/appData/powerd/BlankingMode
        devicestack/appData/powerd/BlankingPath
        devicestack/appData/powerd/DisplaySequence
        devicestack/appData/powerd/SplashScreenSupport"
    for file in ${PLATFORM_SPECIFIC_FILES}
    do
      cmp -s "${DEFAULT_DIR}/$file" "${USERDATA_DIR}/$file" \
          || cp -fp "${DEFAULT_DIR}/$file" "${USERDATA_DIR}/$file"
    done
    echo Z > /dev/watchdog
    ;;
  stop)
    ;;
  *)
    echo "Usage: $0 {start|stop}" >&2
    exit 1
    ;;
esac

exit 0
