#!/bin/sh

ME="[restoretemplates.sh]"

echo "${ME} Enter."

. /opt/gira/share/devicestack/ipmodule-vars

echo -n "${ME} Restoring shadow from template ... "
SHADOW_LINK_TARGET=$(readlink /etc/shadow)
mkdir -p "$(dirname "${SHADOW_LINK_TARGET}")"
if [ -f "${SHADOW_USER_TEMPLATE}" ]
then
  install -m 600 "${SHADOW_USER_TEMPLATE}" "${SHADOW_LINK_TARGET}"
else
  install -m 600 "${SHADOW_TEMPLATE}" "${SHADOW_LINK_TARGET}"
fi
echo "done."

if [ -f "${COMMISSIONED_FILE}" ]
then
  echo -n "${ME} Checking existence of default device user ... "
  if [ -f "${DEFAULT_DEVICE_USER_FILE}" ]
  then
    echo "found."
  else
    echo "not found."
    mkdir -p "${DEVICE_USER_DIR}"

    # If device has initial device password
    if [ -f /opt/extparam/fddp ]
    then
      echo -n "${me} Creating device user with initial device password..."
      install -m 600 /dev/null "${DEFAULT_DEVICE_USER_FILE}"
      echo -n "pwd:" > "${DEFAULT_DEVICE_USER_FILE}"
      IGPW=$(cat /opt/extparam/fddp)
      if /opt/gira/bin/encode-pw.sh "${IGPW}" >> "${DEFAULT_DEVICE_USER_FILE}"
      then
        echo "done."
      else
        echo "failed."
      fi
    else
      echo -n "${me} Creating default device user ... "
      if echo -n "x8q+DQfMqM4+77LfeRWer2C0A5B2kZ4A4kIfAVeJvbw=" > "${DEFAULT_DEVICE_USER_FILE}"
      then
        echo "done."
      else
        echo "failed."
      fi
    fi
  fi

  echo -n "${ME} Checking appconfig.xml ... "
  if [ -f "${APPCONFIG_FILE}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Copying appconfig.xml ... "
    if cp "${APPCONFIG_FILE_TEMPLATE}" "${APPCONFIG_FILE}"
    then
      echo "done."
    else
      echo "failed."
    fi
  fi

  echo -n "${ME} Checking devicestackconfig.xml ... "
  if [ -f "${DSCONFIG_FILE}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Copying devicestackconfig.xml ... "
    if cp "${DSCONFIG_FILE_TEMPLATE}" "${DSCONFIG_FILE}"
    then
      echo "done."
    else
      echo "failed."
    fi
  fi

  echo -n "${ME} Checking custom channel definitions ... "
  if [ -d "${COSTOM_CHANNEL_DIR}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Copying custom channel definitions ... "
    if cp -a "${COSTOM_CHANNEL_DIR_TEMPLATE}" "${COSTOM_CHANNEL_DIR}"
    then
      echo "done."
    else
      echo "failed."
    fi
  fi

  echo -n "${ME} Checking network.conf ... "
  if [ -d "${NETWORK_CFG_FILE}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Copying network.conf ... "
    if cp -a "${NETWORK_CFG_FILE_TEMPLATE}" "${NETWORK_CFG_FILE}"
    then
      echo "done."
    else
      echo "failed."
    fi
  fi

  # FIXME_G1
  # Clarify if this is actually needed and enable or delete below.
  echo -n "${ME} Checking custom project definitions ... "
  if [ -d "${CUSTOM_PROJECT_DEFINITION_DIR}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Copying custom project definitions ... "
    if cp -a "${CUSTOM_PROJECT_DEFINITION_DIR_TEMPLATE}" "${CUSTOM_PROJECT_DEFINITION_DIR}"
    then
      echo "done."
    else
      echo "failed."
    fi
  fi

  echo -n "${ME} Checking connman configuration directory ... "
  if [ -d "${CONNMAN_CONFIG_DIR}" ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Creating connman configuration directory ... "
    if mkdir -p "${CONNMAN_CONFIG_DIR}"
    then
      echo " Done."
      echo -n "${ME} Copying connman templates ... "
      cp "${CONNMAN_TEMPLATE_DIR}/settings" "${CONNMAN_CONFIG_DIR}"
      echo "Done."
    else
      echo "Failed!"
    fi
  fi
  
  echo -n "${ME} Checking directory for random seed ... "
  if [ -d "${MP_USERDATA}"/urandom ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Creating directory for random seed ... "
    if mkdir "${MP_USERDATA}"/urandom
    then
      echo "Done"
    else
      echo "Failed!"
    fi
  fi
  
  echo -n "${ME} Checking link to localtime ... "
  if [ -h "${DS_ETC_USERDATA}"/timezone ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Creating link to timezone Europe/Berlin ... "
    if ln -sf /usr/share/zoneinfo/Europe/Berlin "${DS_ETC_USERDATA}"/timezone
    then
      echo "Done"
    else
      echo "Failed!"
    fi
  fi
  
  echo -n "${ME} Checking link for wpa-supplicant service ... "
  if [ -h "${WPA_SERVICE_CONFIG_DIR}"/fi.w1.wpa_supplicant1.service ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Creating link to wpa-supplicant service template ... "
    mkdir -p "${WPA_SERVICE_CONFIG_DIR}"
    if ln -sf "${WPA_TEMPLATE_DIR}"/fi.w1.wpa_supplicant1.service "${WPA_SERVICE_CONFIG_DIR}"/fi.w1.wpa_supplicant1.service
    then
      echo "Done"
    else
      echo "Failed!"
    fi
  fi

  echo -n "${ME} Checking ntp drift file ... "
  if [ -f "${MP_USERDATA}"/ntp.drift ]
  then
    echo "found."
  else
    echo "not found."
    echo -n "${ME} Restoring ntp drift file from template ... "
    if cp "${DS_TEMPLATE_DIR}"/ntp.drift.template "${MP_USERDATA}"/ntp.drift
    then
      echo "Done"
    else
      echo "Failed!"
    fi
  fi
fi

echo "${ME} Exit."

exit 0
