-- KNX Download Handler
-- Module with specific functions to G1
local g1 = require("knxappprghandler_urn")

local function has_value(tab, val)
  for index, value in ipairs(tab) do
    if value == val then
      return true
    end
  end

  return false
end

-- Type = Bool, Int8, Int16, Int32, UInt8, UInt16, UInt32, Float16, Float32, Name (String comes from MemoryData - length 160) Text (String comes from MemoryData - length 80), GENERIC_20 (String comes from Property), Url
local FunctionDefinition = {}
-- Switch
FunctionDefinition[1] =
{

  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Switch",
    ChannelUrn = "de.gira.schema.channels.Switch"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "Type", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionSwitchType},
    {Key = "Command", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionButtonType},
    {Key = "OnAction", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnActionOffset},
    {Key = "OffAction", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffActionOffset},
    {Key = "ShowStatus", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowStatus},
    {Key = "OnColor", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionOnColor},
    {Key = "OffColor", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionOffColor},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset}
  }
}

-- Dimmer
FunctionDefinition[2] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Light",
    ChannelUrn = "de.gira.schema.channels.Dimmer"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "DefaultShift", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionDefaultShift},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepDimTimeout, Digits = 1},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset}
  }
}

-- KNXDimmer
FunctionDefinition[3] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.KNX.Light",
    ChannelUrn = "de.gira.schema.channels.KNX.Dimmer"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepDimTimeout, Digits = 1},
    {Key = "ShowStatus", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowStatus},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset}
  }
}

-- ShutterAndBlind
FunctionDefinition[4] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Covering",
    ChannelUrn = "de.gira.schema.channels.BlindWithPos"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepMoveTimeout, Digits = 1}
  }
}

-- BlindWithPositioning
FunctionDefinition[5] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Covering",
    ChannelUrn = "de.gira.schema.channels.BlindWithPos"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepMoveTimeout, Digits = 1}
  }
}

-- ShutterWithPositioning
FunctionDefinition[6] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Covering",
    ChannelUrn = "de.gira.schema.channels.BlindWithPos"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepMoveTimeout, Digits = 1}
  }
}

-- SceneControl
FunctionDefinition[7] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Scene",
    ChannelUrn = "de.gira.schema.channels.SceneControl"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "Scene", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionSceneNumber},
    {Key = "CanLearn", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionSceneCanLearn}
  }
}

-- ValueTransmitter
local ShowIfDataTypePercent =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 0 or statusType == 1
  end
}

local ShowHasStepSize =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 0 or statusType == 1 or statusType == 2 or statusType == 3
  end
}

local ShowIfDataTypeFrom0To100 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 0
  end
}

local ShowIfDataTypeFrom0To255 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 1 or statusType == 2
  end
}

local ShowIfDataTypeFromN128To127 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 3
  end
}

local ShowIfDataTypeFromN99To99 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 4
  end
}

local ShowIfDataTypeRangeU8 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 5
  end
}

local ShowIfDataTypeRangeU16 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 6
  end
}

local ShowIfDataTypeRangeU32 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 7
  end
}

local ShowIfDataTypeRangeS8 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 8
  end
}

local ShowIfDataTypeRangeS16 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 9
  end
}

local ShowIfDataTypeRangeS32 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 10
  end
}

local ShowIfDataTypeRangeD16 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 11
  end
}

local ShowIfDataTypeRangeD32 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 12
  end
}

local ShowIfDataTypeRangeD16OrD32 =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransValueType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 11 or statusType == 12
  end
}

FunctionDefinition[8] =
{
  VariableUrns =
  {
    IndexProperty = g1.ExtendedPropertyTable.FunctionTransValueType,
    Urns =
    {
      [0] =
      {
        FunctionUrn = "de.gira.schema.functions.PercentValue",
        ChannelUrn = "de.gira.schema.channels.Percent"
      },
      [1] =
      {
        FunctionUrn = "de.gira.schema.functions.PercentValue",
        ChannelUrn = "de.gira.schema.channels.Percent",
        LuaTemplateIndex = "5004"
      },
      [2] =
      {
        FunctionUrn = "de.gira.schema.functions.Unsigned8BitValue",
        ChannelUrn = "de.gira.schema.channels.Byte",
        LuaTemplateIndex = "5010"
      },
      [3] =
      {
        FunctionUrn = "de.gira.schema.functions.Signed8BitValue",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "6010"
      },
      [4] =
      {
        FunctionUrn = "de.gira.schema.functions.TemperatureValue",
        ChannelUrn = "de.gira.schema.channels.Temperature"
      },
      [5] =
      {
        FunctionUrn = "de.gira.schema.functions.UnsignedValue",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "5010"
      },
      [6] =
      {
        FunctionUrn = "de.gira.schema.functions.UnsignedValue",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "7001"
      },
      [7] =
      {
        FunctionUrn = "de.gira.schema.functions.UnsignedValue",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "12001"
      },
      [8] =
      {
        FunctionUrn = "de.gira.schema.functions.SignedValue",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "6010"
      },
      [9] =
      {
        FunctionUrn = "de.gira.schema.functions.SignedValue",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "8001"
      },
      [10] =
      {
        FunctionUrn = "de.gira.schema.functions.SignedValue",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "13001"
      },
      [11] =
      {
        FunctionUrn = "de.gira.schema.functions.DecimalValue",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "9000"
      },
      [12] =
      {
        FunctionUrn = "de.gira.schema.functions.DecimalValue",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "14000"
      }
    }
  },
  Parameters =
  {
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "Type", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueType, ShowIf = ShowIfDataTypePercent},

    --From0To100
    {Key = "Minimum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMin100, ShowIf = ShowIfDataTypeFrom0To100},
    {Key = "Maximum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMax100, ShowIf = ShowIfDataTypeFrom0To100},
    {Key = "Value", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueDef100, ShowIf = ShowIfDataTypeFrom0To100},
    --From0To255
    {Key = "Minimum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMin255, ShowIf = ShowIfDataTypeFrom0To255},
    {Key = "Maximum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMax255, ShowIf = ShowIfDataTypeFrom0To255},
    {Key = "Value", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueDef255, ShowIf = ShowIfDataTypeFrom0To255},
    --FromN128To127
    {Key = "Minimum", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueMin128, ShowIf = ShowIfDataTypeFromN128To127},
    {Key = "Maximum", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueMax127, ShowIf = ShowIfDataTypeFromN128To127},
    {Key = "Value", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueDef127, ShowIf = ShowIfDataTypeFromN128To127},
    --FromN99To99
    {Key = "Minimum", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueMin99, ShowIf = ShowIfDataTypeFromN99To99},
    {Key = "Maximum", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueMax99, ShowIf = ShowIfDataTypeFromN99To99},
    {Key = "Value", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueDef99, ShowIf = ShowIfDataTypeFromN99To99},
    --RangeU8
    {Key = "Minimum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMinU8, ShowIf = ShowIfDataTypeRangeU8},
    {Key = "Maximum", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxU8, ShowIf = ShowIfDataTypeRangeU8},
    {Key = "Value", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueDefU8, ShowIf = ShowIfDataTypeRangeU8},
    --RangeU16
    {Key = "Minimum", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionTransValueMinU16, ShowIf = ShowIfDataTypeRangeU16},
    {Key = "Maximum", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxU16, ShowIf = ShowIfDataTypeRangeU16},
    {Key = "Value", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionTransValueDefU16, ShowIf = ShowIfDataTypeRangeU16},
    --RangeU32
    {Key = "Minimum", Type = "UInt32", Property = g1.ExtendedPropertyTable.FunctionTransValueMinU32, ShowIf = ShowIfDataTypeRangeU32},
    {Key = "Maximum", Type = "UInt32", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxU32, ShowIf = ShowIfDataTypeRangeU32},
    {Key = "Value", Type = "UInt32", Property = g1.ExtendedPropertyTable.FunctionTransValueDefU32, ShowIf = ShowIfDataTypeRangeU32},
    --RangeS8
    {Key = "Minimum", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueMinS8, ShowIf = ShowIfDataTypeRangeS8},
    {Key = "Maximum", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxS8, ShowIf = ShowIfDataTypeRangeS8},
    {Key = "Value", Type = "Int8", Property = g1.ExtendedPropertyTable.FunctionTransValueDefS8, ShowIf = ShowIfDataTypeRangeS8},
    --RangeS16
    {Key = "Minimum", Type = "Int16", Property = g1.ExtendedPropertyTable.FunctionTransValueMinS16, ShowIf = ShowIfDataTypeRangeS16},
    {Key = "Maximum", Type = "Int16", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxS16, ShowIf = ShowIfDataTypeRangeS16},
    {Key = "Value", Type = "Int16", Property = g1.ExtendedPropertyTable.FunctionTransValueDefS16, ShowIf = ShowIfDataTypeRangeS16},
    --RangeS32
    {Key = "Minimum", Type = "Int32", Property = g1.ExtendedPropertyTable.FunctionTransValueMinS32, ShowIf = ShowIfDataTypeRangeS32},
    {Key = "Maximum", Type = "Int32", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxS32, ShowIf = ShowIfDataTypeRangeS32},
    {Key = "Value", Type = "Int32", Property = g1.ExtendedPropertyTable.FunctionTransValueDefS32, ShowIf = ShowIfDataTypeRangeS32},
    --RangeD16
    {Key = "Minimum", Type = "Float16", Property = g1.ExtendedPropertyTable.FunctionTransValueMinD16, ShowIf = ShowIfDataTypeRangeD16, Digits = 3},
    {Key = "Maximum", Type = "Float16", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxD16, ShowIf = ShowIfDataTypeRangeD16, Digits = 3},
    {Key = "Value", Type = "Float16", Property = g1.ExtendedPropertyTable.FunctionTransValueDefD16, ShowIf = ShowIfDataTypeRangeD16, Digits = 3},
    --RangeD32
    {Key = "Minimum", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueMinD32, ShowIf = ShowIfDataTypeRangeD32, Digits = 3},
    {Key = "Maximum", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueMaxD32, ShowIf = ShowIfDataTypeRangeD32, Digits = 3},
    {Key = "Value", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionTransValueDefD32, ShowIf = ShowIfDataTypeRangeD32, Digits = 3},

    {Key = "Unit", Type = "GENERIC_20", Property = g1.ExtendedPropertyTable.FunctionTransValueUnit},
    {Key = "CanChange", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionTransValueCanChange},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransValueStepsize, ShowIf = ShowHasStepSize},
    {Key = "ShowCurrentValue", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionTransValueShowCur},
    {Key = "DecimalDigits", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransStatusDigits, ShowIf = ShowIfDataTypeRangeD16OrD32}
  }
}

-- StatusValue
local ShowIfDataTypeBinary =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransStatusType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType == 0
  end
}

local ShowNotIfDataTypeBinary =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransStatusType, Type = "UInt8"}
  },
  Function = function(statusType)
    return statusType ~= 0
  end
}

local ShowIfDataTypeNumeric =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransStatusType, Type = "UInt8"}
  },
  Function = function(statusType)
    return has_value({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, statusType)
  end
}

local ShowIfDataTypeFloat =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FunctionTransStatusType, Type = "UInt8"}
  },
  Function = function(statusType)
    return has_value({1, 2, 3, 8, 9, 12}, statusType)
  end
}

FunctionDefinition[9] =
{
  VariableUrns =
  {
    IndexProperty = g1.ExtendedPropertyTable.FunctionTransStatusType,
    Urns =
    {
      [0] =
      {
        FunctionUrn = "de.gira.schema.functions.BinaryStatus",
        ChannelUrn = "de.gira.schema.channels.Binary"
      },
      [1] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R5001"
      },
      [2] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R5003"
      },
      [3] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R5004"
      },
      [4] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericUnsignedStatus",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "R5010"
      },
      [5] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericSignedStatus",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "R6010"
      },
      [6] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericUnsignedStatus",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "R7001"
      },
      [7] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericSignedStatus",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "R8001"
      },
      [8] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R9001"
      },
      [9] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R9004"
      },
      [10] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericUnsignedStatus",
        ChannelUrn = "de.gira.schema.channels.DWord",
        LuaTemplateIndex = "R12001"
      },
      [11] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericSignedStatus",
        ChannelUrn = "de.gira.schema.channels.Integer",
        LuaTemplateIndex = "R13001"
      },
      [12] =
      {
        FunctionUrn = "de.gira.schema.functions.NumericFloatStatus",
        ChannelUrn = "de.gira.schema.channels.Float",
        LuaTemplateIndex = "R14000"
      },
      [13] =
      {
        FunctionUrn = "de.gira.schema.functions.TextStatus",
        ChannelUrn = "de.gira.schema.channels.String"
      }
    }
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "OnColor", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionOnColor, ShowIf = ShowIfDataTypeBinary},
    {Key = "OffColor", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionOffColor, ShowIf = ShowIfDataTypeBinary},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset, ShowIf = ShowIfDataTypeBinary},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset, ShowIf = ShowIfDataTypeBinary},
    {Key = "Unit", Type = "GENERIC_20", Property = g1.ExtendedPropertyTable.FunctionTransStatusUnit, ShowIf = ShowIfDataTypeNumeric},
    {Key = "Description", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionTransStatusDescOffset, ShowIf = ShowNotIfDataTypeBinary},
    {Key = "DecimalDigits", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTransStatusDigits, ShowIf = ShowIfDataTypeFloat}
  }
}

-- TriggerOnOff
FunctionDefinition[10] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Trigger",
    ChannelUrn = "de.gira.schema.channels.Trigger"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "Command", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTriggerCommand},
    {Key = "Color", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionColor},
    {Key = "Text", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionTextOffset}
  }
}

-- ColoredLightRGB
FunctionDefinition[11] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.ColoredLight",
    ChannelUrn = "de.gira.schema.channels.DimmerRGBW"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "DefaultShift", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionDefaultShift},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepDimTimeout, Digits = 1},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset}
  }
}

-- ColoredLightRGBW
FunctionDefinition[12] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.ColoredLight",
    ChannelUrn = "de.gira.schema.channels.DimmerRGBW"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "DefaultShift", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionDefaultShift},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepDimTimeout, Digits = 1},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset}
  }
}

-- TunableWhite
FunctionDefinition[13] =
{
  VariableUrns =
  {
    IndexProperty = g1.ExtendedPropertyTable.ColorTemp9002,
    Urns =
    {
      [0] =
      {
	    FunctionUrn = "de.gira.schema.functions.TunableLight",
	    ChannelUrn = "de.gira.schema.channels.DimmerWhite",
	    LuaTemplateIndex = "7600"
      },
      [1] =
      {
	    FunctionUrn = "de.gira.schema.functions.TunableLight",
	    ChannelUrn = "de.gira.schema.channels.DimmerWhite",
	    LuaTemplateIndex = "9002"
      }
	}
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "DefaultShift", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionDefaultShift},
    {Key = "ButtonTimeout", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionStepDimTimeout, Digits = 1},
    {Key = "OnText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOnTextOffset},
    {Key = "OffText", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionOffTextOffset},
    {Key = "ColorTempMin", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionMinColorTemp},
    {Key = "ColorTempMax", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionMaxColorTemp}
  }
}

-- KNXHeatingCooling
FunctionDefinition[14] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.KNX.HeatingCooling",
    ChannelUrn = "de.gira.schema.channels.KNX.HeatingCoolingSwitchable"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "SetPointRangeMin", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMin, Digits = 1},
    {Key = "SetPointRangeMax", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMax, Digits = 1},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionSetpointShift},
    {Key = "StatusType", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionHVACStatusType},
    {Key = "HeatCool", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionHeatCoolMode},
    {Key = "ShowPresenceButton", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionHeatCoolPresence}
  }
}

-- KNXHeatingCoolingSwitchable
FunctionDefinition[15] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.KNX.HeatingCooling",
    ChannelUrn = "de.gira.schema.channels.KNX.HeatingCoolingSwitchable"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "SetPointRangeMin", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMin, Digits = 1},
    {Key = "SetPointRangeMax", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMax, Digits = 1},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionSetpointShift},
    {Key = "StatusType", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionHVACStatusType},
    {Key = "HeatCool", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionHeatCoolMode},
    {Key = "ShowPresenceButton", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionHeatCoolPresence}
  }
}

-- KNXFanCoil
--- ModeValue
local function ShowModeValueFunc(show, mode)
    return show == 1 and mode == 0
end

local ShowModeAutoValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowAuto, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilUseKnxMode, Type = "UInt8"}
  },
  Function = ShowModeValueFunc
}

local ShowModeHeatValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowHeat, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilUseKnxMode, Type = "UInt8"}
  },
  Function = ShowModeValueFunc
}

local ShowModeCoolValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowCool, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilUseKnxMode, Type = "UInt8"}
  },
  Function = ShowModeValueFunc
}

local ShowModeFanOnlyValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanonly, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilUseKnxMode, Type = "UInt8"}
  },
  Function = ShowModeValueFunc
}

local ShowModeDehumValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowDehum, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilUseKnxMode, Type = "UInt8"}
  },
  Function = ShowModeValueFunc
}

---FanSpeedLevel
local function ShowOnFanSpeelLevel(showFanSpeedLevel)
    return showFanSpeedLevel == 1
end

local ShowFanSpeedLevelAutoStopMax =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
  },
  Function = ShowOnFanSpeelLevel
}

local function ShowFanSpeedLevelAutoStopMaxLevel(showFanSpeedLevel, showFanSpeedLevelAutoStopMax, valueType)
    return ShowOnFanSpeelLevel(showFanSpeedLevel) and showFanSpeedLevelAutoStopMax == 1 and valueType == 0
end

local function ShowFanSpeedLevelAutoStopMaxValue(showFanSpeedLevel, showFanSpeedLevelAutoStopMax, valueType)
    return ShowOnFanSpeelLevel(showFanSpeedLevel) and showFanSpeedLevelAutoStopMax == 1 and valueType == 1
end

----FanSpeedLevelAuto
local ShowFanSpeedLevelAutoLevel =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelAuto, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxLevel
}

local ShowFanSpeedLevelAutoValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelAuto, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxValue
}

----FanSpeedLevelStop
local ShowFanSpeedLevelStopLevel =
{
PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelStop, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxLevel
}

local ShowFanSpeedLevelStopValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelStop, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxValue
}

----FanSpeedLevelMaximum
local ShowFanSpeedLevelMaxLevel =
{
PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelMax, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxLevel
}

local ShowFanSpeedLevelMaxValue =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelMax, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
  },
  Function = ShowFanSpeedLevelAutoStopMaxValue
}

---FanSpeedLevel 1-5
local ShowNumberFanSpeedLevel =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"}
  },
  Function = function(value)
    return value == 1
  end
}

local ShowFanSpeedLevelPropertyIds =
{
    {Id = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilNumberFanSpeedLevel, Type = "UInt8"}
}

local function ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, sollShowFanSpeedLevel, sollValueType, sollNumberFanSpeedLevel)
    return showFanSpeedLevel == sollShowFanSpeedLevel and valueType == sollValueType and numberFanSpeedLevel >= sollNumberFanSpeedLevel
end

local ShowFanSpeedLevel1 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 0, 0)
  end
}

local ShowFanSpeedLevel2 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 0, 1)
  end
}

local ShowFanSpeedLevel3 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 0, 2)
  end
}

local ShowFanSpeedLevel4 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 0, 3)
  end
}

local ShowFanSpeedLevel5 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 0, 4)
  end
}

local ShowFanSpeedValue1 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 1, 0)
  end
}

local ShowFanSpeedValue2 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 1, 1)
  end
}

local ShowFanSpeedValue3 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 1, 2)
  end
}

local ShowFanSpeedValue4 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 1, 3)
  end
}

local ShowFanSpeedValue5 =
{
  PropertyIds = ShowFanSpeedLevelPropertyIds,
  Function = function(showFanSpeedLevel, valueType, numberFanSpeedLevel)
    return ShowFanSpeedLevelValue(showFanSpeedLevel, valueType, numberFanSpeedLevel, 1, 1, 4)
  end
}


---ShowHorizontalVertical
local function ShowFanCoilShowHorizVertiLevelValue(showFanHorizVertiLevel, valueType, numberFanSpeedLevel, sollShowFanHorizVertiLevel, sollValueType, sollNumberFanSpeedLevel)
    return showFanHorizVertiLevel == sollShowFanHorizVertiLevel and valueType == sollValueType and numberFanSpeedLevel >= sollNumberFanSpeedLevel
end

---ShowHorizontal
local ShowHorizLevel =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowHorizLevel, Type = "UInt8"}
  },
  Function = function(value)
    return value == 1
  end
}

local ShowFanCoilShowHorizStopMovePropertyIds =
{
    {Id = g1.ExtendedPropertyTable.FanCoilShowHorizStopMove, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowHorizLevel, Type = "UInt8"}
}

local ShowFanCoilShowHorizStopMove01 =
{
  PropertyIds = ShowFanCoilShowHorizStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and level == 0
  end
}

local ShowFanCoilShowHorizStopMove0100 =
{
  PropertyIds = ShowFanCoilShowHorizStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and valueType == 1 and level == 1
  end
}

local ShowFanCoilShowHorizStopMove0255 =
{
  PropertyIds = ShowFanCoilShowHorizStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and valueType == 0 and level == 1
  end
}

local ShowFanCoilShowHorizLevelValuePropertyIds =
{
    {Id = g1.ExtendedPropertyTable.FanCoilShowHorizLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilNumberHorizLevel, Type = "UInt8"}
}

local ShowFanCoilShowHorizLevel1 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 0)
  end
}

local ShowFanCoilShowHorizLevel2 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 1)
  end
}

local ShowFanCoilShowHorizLevel3 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 2)
  end
}

local ShowFanCoilShowHorizLevel4 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 3)
  end
}

local ShowFanCoilShowHorizLevel5 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 4)
  end
}

local ShowFanCoilShowHorizValue1 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 0)
  end
}

local ShowFanCoilShowHorizValue2 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 1)
  end
}

local ShowFanCoilShowHorizValue3 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 2)
  end
}

local ShowFanCoilShowHorizValue4 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 3)
  end
}

local ShowFanCoilShowHorizValue5 =
{
  PropertyIds = ShowFanCoilShowHorizLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 4)
  end
}

---ShowVertical
local ShowVertiLevel =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.FanCoilShowVertiLevel, Type = "UInt8"}
  },
  Function = function(value)
    return value == 1
  end
}

local ShowFanCoilShowVertiStopMovePropertyIds =
{
    {Id = g1.ExtendedPropertyTable.FanCoilShowVertiStopMove, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilShowVertiLevel, Type = "UInt8"}
}

local ShowFanCoilShowVertiStopMove01 =
{
  PropertyIds = ShowFanCoilShowVertiStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and level == 0
  end
}

local ShowFanCoilShowVertiStopMove0100 =
{
  PropertyIds = ShowFanCoilShowVertiStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and valueType == 1 and level == 1
  end
}

local ShowFanCoilShowVertiStopMove0255 =
{
  PropertyIds = ShowFanCoilShowVertiStopMovePropertyIds,
  Function = function(value, valueType, level)
    return value == 1 and valueType == 0 and level == 1
  end
}

local ShowFanCoilShowVertiLevelValuePropertyIds =
{
    {Id = g1.ExtendedPropertyTable.FanCoilShowVertiLevel, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilValueType, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.FanCoilNumberVertiLevel, Type = "UInt8"}
}

local ShowFanCoilShowVertiLevel1 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 0)
  end
}

local ShowFanCoilShowVertiLevel2 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 1)
  end
}

local ShowFanCoilShowVertiLevel3 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 2)
  end
}

local ShowFanCoilShowVertiLevel4 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 3)
  end
}

local ShowFanCoilShowVertiLevel5 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 0, 4)
  end
}

local ShowFanCoilShowVertiValue1 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 0)
  end
}

local ShowFanCoilShowVertiValue2 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 1)
  end
}

local ShowFanCoilShowVertiValue3 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 2)
  end
}

local ShowFanCoilShowVertiValue4 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 3)
  end
}

local ShowFanCoilShowVertiValue5 =
{
  PropertyIds = ShowFanCoilShowVertiLevelValuePropertyIds,
  Function = function(value, valueType, number)
    return ShowFanCoilShowHorizVertiLevelValue(value, valueType, number, 1, 1, 4)
  end
}

FunctionDefinition[16] =
{
  VariableUrns =
  {
    IndexProperty = g1.ExtendedPropertyTable.FanCoilValueType,
    Urns =
    {
      [0] =
      {
        FunctionUrn = "de.gira.schema.functions.KNX.FanCoil",
        ChannelUrn = "de.gira.schema.channels.KNX.FanCoil"
      },
      [1] =
      {
        FunctionUrn = "de.gira.schema.functions.KNX.FanCoilScaling",
        ChannelUrn = "de.gira.schema.channels.KNX.FanCoilScaling"
      }
    }
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "SetPointRangeMin", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMin, Digits = 1},
    {Key = "SetPointRangeMax", Type = "Float32", Property = g1.ExtendedPropertyTable.FunctionSetpointMax, Digits = 1},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionSetpointShift},
    {Key = "ShowModeAuto", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowAuto},
    {Key = "ShowModeHeat", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowHeat},
    {Key = "ShowModeCool", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowCool},
    {Key = "ShowModeFanOnly", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowFanonly},
    {Key = "ShowModeDehumidification", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowDehum},
    {Key = "KnxMode20105", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilUseKnxMode},
    {Key = "ModeAutoValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilValueModeAuto, ShowIf = ShowModeAutoValue},
    {Key = "ModeHeatValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilValueModeHeat, ShowIf = ShowModeHeatValue},
    {Key = "ModeCoolValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilValueModeCool, ShowIf = ShowModeCoolValue},
    {Key = "ModeFanOnlyValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilValueModeFanOnly, ShowIf = ShowModeFanOnlyValue},
    {Key = "ModeDehumidificationValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilValueModeDehum, ShowIf = ShowModeDehumValue},

    {Key = "ShowFanSpeedLevel", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevel},
    {Key = "FanSpeedLevel", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilNumberFanSpeedLevel, ShowIf = ShowFanSpeedLevelAutoStopMax},

    {Key = "FanSpeedLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevel1, ShowIf = ShowFanSpeedLevel1},
    {Key = "FanSpeedLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevel2, ShowIf = ShowFanSpeedLevel2},
    {Key = "FanSpeedLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevel3, ShowIf = ShowFanSpeedLevel3},
    {Key = "FanSpeedLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevel4, ShowIf = ShowFanSpeedLevel4},
    {Key = "FanSpeedLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevel5, ShowIf = ShowFanSpeedLevel5},

    {Key = "FanSpeedLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValue1, ShowIf = ShowFanSpeedValue1},
    {Key = "FanSpeedLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValue2, ShowIf = ShowFanSpeedValue2},
    {Key = "FanSpeedLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValue3, ShowIf = ShowFanSpeedValue3},
    {Key = "FanSpeedLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValue4, ShowIf = ShowFanSpeedValue4},
    {Key = "FanSpeedLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValue5, ShowIf = ShowFanSpeedValue5},

    {Key = "ShowFanSpeedLevelAuto", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelAuto, ShowIf = ShowFanSpeedLevelAutoStopMax},
    {Key = "ShowFanSpeedLevelStop", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelStop, ShowIf = ShowFanSpeedLevelAutoStopMax},
    {Key = "ShowFanSpeedLevelMax", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowFanSpeedLevelMax, ShowIf = ShowFanSpeedLevelAutoStopMax},

    {Key = "FanSpeedLevelAuto", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevelAuto, ShowIf = ShowFanSpeedLevelAutoLevel},
    {Key = "FanSpeedLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevelStop, ShowIf = ShowFanSpeedLevelStopLevel},
    {Key = "FanSpeedLevelMax", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedLevelMax, ShowIf = ShowFanSpeedLevelMaxLevel},

    {Key = "FanSpeedLevelAuto", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValueAuto, ShowIf = ShowFanSpeedLevelAutoValue},
    {Key = "FanSpeedLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValueStop, ShowIf = ShowFanSpeedLevelStopValue},
    {Key = "FanSpeedLevelMax", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilFanSpeedValueMax, ShowIf = ShowFanSpeedLevelMaxValue},


    {Key = "ShowFanLeftRightLevel", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowHorizLevel},
    {Key = "ShowFanLeftRightStopMove", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowHorizStopMove},
    {Key = "FanLeftRightLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizStopLevel, ShowIf = ShowFanCoilShowHorizStopMove0255},
    {Key = "FanLeftRightLevelMove", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizMoveLevel, ShowIf = ShowFanCoilShowHorizStopMove0255},
    {Key = "FanLeftRightStopValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizStopValue01, ShowIf = ShowFanCoilShowHorizStopMove01},
    {Key = "FanLeftRightMoveValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizMoveValue01, ShowIf = ShowFanCoilShowHorizStopMove01},
    {Key = "FanLeftRightLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizStopValue, ShowIf = ShowFanCoilShowHorizStopMove0100},
    {Key = "FanLeftRightLevelMove", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizMoveValue, ShowIf = ShowFanCoilShowHorizStopMove0100},

    {Key = "FanLeftRightLevel", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilNumberHorizLevel, ShowIf = ShowHorizLevel},
    {Key = "FanLeftRightLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizLevel1, ShowIf = ShowFanCoilShowHorizLevel1},
    {Key = "FanLeftRightLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizLevel2, ShowIf = ShowFanCoilShowHorizLevel2},
    {Key = "FanLeftRightLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizLevel3, ShowIf = ShowFanCoilShowHorizLevel3},
    {Key = "FanLeftRightLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizLevel4, ShowIf = ShowFanCoilShowHorizLevel4},
    {Key = "FanLeftRightLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizLevel5, ShowIf = ShowFanCoilShowHorizLevel5},
    {Key = "FanLeftRightLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizValue1, ShowIf = ShowFanCoilShowHorizValue1},
    {Key = "FanLeftRightLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizValue2, ShowIf = ShowFanCoilShowHorizValue2},
    {Key = "FanLeftRightLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizValue3, ShowIf = ShowFanCoilShowHorizValue3},
    {Key = "FanLeftRightLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizValue4, ShowIf = ShowFanCoilShowHorizValue4},
    {Key = "FanLeftRightLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilHorizValue5, ShowIf = ShowFanCoilShowHorizValue5},


    {Key = "ShowFanUpDownLevel", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowVertiLevel},
    {Key = "ShowFanUpDownStopMove", Type = "Bool", Property = g1.ExtendedPropertyTable.FanCoilShowVertiStopMove},
    {Key = "FanUpDownLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiStopLevel, ShowIf = ShowFanCoilShowVertiStopMove0255},
    {Key = "FanUpDownLevelMove", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiMoveLevel, ShowIf = ShowFanCoilShowVertiStopMove0255},
    {Key = "FanUpDownStopValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiStopValue01, ShowIf = ShowFanCoilShowVertiStopMove01},
    {Key = "FanUpDownMoveValue", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiMoveValue01, ShowIf = ShowFanCoilShowVertiStopMove01},
    {Key = "FanUpDownLevelStop", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiStopValue, ShowIf = ShowFanCoilShowVertiStopMove0100},
    {Key = "FanUpDownLevelMove", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiMoveValue, ShowIf = ShowFanCoilShowVertiStopMove0100},

    {Key = "FanUpDownLevel", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilNumberVertiLevel, ShowIf = ShowVertiLevel},
    {Key = "FanUpDownLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiLevel1, ShowIf = ShowFanCoilShowVertiLevel1},
    {Key = "FanUpDownLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiLevel2, ShowIf = ShowFanCoilShowVertiLevel2},
    {Key = "FanUpDownLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiLevel3, ShowIf = ShowFanCoilShowVertiLevel3},
    {Key = "FanUpDownLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiLevel4, ShowIf = ShowFanCoilShowVertiLevel4},
    {Key = "FanUpDownLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiLevel5, ShowIf = ShowFanCoilShowVertiLevel5},
    {Key = "FanUpDownLevel1", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiValue1, ShowIf = ShowFanCoilShowVertiValue1},
    {Key = "FanUpDownLevel2", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiValue2, ShowIf = ShowFanCoilShowVertiValue2},
    {Key = "FanUpDownLevel3", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiValue3, ShowIf = ShowFanCoilShowVertiValue3},
    {Key = "FanUpDownLevel4", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiValue4, ShowIf = ShowFanCoilShowVertiValue4},
    {Key = "FanUpDownLevel5", Type = "UInt8", Property = g1.ExtendedPropertyTable.FanCoilVertiValue5, ShowIf = ShowFanCoilShowVertiValue5}
  }
}

-- Audio
FunctionDefinition[17] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Audio",
    ChannelUrn = "de.gira.schema.channels.AudioWithPlaylist"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome}
  }
}

-- AudioMedia
FunctionDefinition[18] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Audio",
    ChannelUrn = "de.gira.schema.channels.AudioWithPlaylist"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome}
  }
}

-- AudioPlaylist
FunctionDefinition[19] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Audio",
    ChannelUrn = "de.gira.schema.channels.AudioWithPlaylist"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome}
  }
}

-- IpCamera
FunctionDefinition[20] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Camera",
    ChannelUrn = "de.gira.schema.channels.Camera"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "VideoURI", Type = "Url", Property = g1.ExtendedPropertyTable.IpCamUrlOffset},
    {Key = "VideoCodec", Type = "UInt8", Property = g1.ExtendedPropertyTable.IpCamCodec}
  }
}

-- Sauna
FunctionDefinition[21] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.SaunaHeating",
    ChannelUrn = "de.gira.schema.channels.RoomTemperatureSwitchable"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "Range", Type = "UInt8", Property = g1.ExtendedPropertyTable.SaunaHeatingTempRange},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.SaunaHeatingSetpointShift}
  }
}

-- SaunaSwitchable
FunctionDefinition[22] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.SaunaHeating",
    ChannelUrn = "de.gira.schema.channels.RoomTemperatureSwitchable"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "ShowTimer", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowTimer},
    {Key = "Range", Type = "UInt8", Property = g1.ExtendedPropertyTable.SaunaHeatingTempRange},
    {Key = "StepSize", Type = "UInt8", Property = g1.ExtendedPropertyTable.SaunaHeatingSetpointShift}
  }
}

-- PressAndHold
FunctionDefinition[23] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.PressAndHold",
    ChannelUrn = "de.gira.schema.channels.Trigger"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "Command", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTriggerCommand},
    {Key = "Color", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionColor},
    {Key = "Text", Type = "Text", Property = g1.ExtendedPropertyTable.FunctionTextOffset},
    {Key = "ReleaseCommand", Type = "UInt8", Property = g1.ExtendedPropertyTable.FunctionTriggerReleaseCommand}
  }
}

-- IpLink
FunctionDefinition[24] =
{
  Urns =
  {
    FunctionUrn = "de.gira.schema.functions.Link",
    ChannelUrn = "de.gira.schema.channels.Link"
  },
  Parameters =
  {
    {Key = "IconId", Type = "UInt16", Property = g1.ExtendedPropertyTable.FunctionIcon},
    {Key = "ShowOnHomeScreen", Type = "Bool", Property = g1.ExtendedPropertyTable.FunctionShowOnHome},
    {Key = "LinkURI", Type = "Url", Property = g1.ExtendedPropertyTable.IpCamUrlOffset}
  }
}

local StaticData = {}

local ShowRoomUnitText =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RoomTempUnitUse, Type = "Bool"}
  },
  Function = function(roomTempUnitUse)
    return roomTempUnitUse
  end
}

StaticData["RoomTemperatureDetection"] =
{
  EnabledProperty = g1.ExtendedPropertyTable.RoomTempUse,
  Type = "setting",
  Parameters =
  {
    {Key = "RoomTempUse", Type = "Bool", Property = g1.ExtendedPropertyTable.RoomTempUse},
    {Key = "RoomTempUnitUse", Type = "Bool", Property = g1.ExtendedPropertyTable.RoomTempUnitUse},
    {Key = "RoomTempUnitText", Type = "GENERIC_20", Property = g1.ExtendedPropertyTable.RoomTempUnitText, ShowIf = ShowRoomUnitText},
    {Key = "RoomTempSensorType", Type = "UInt8", Property = g1.ExtendedPropertyTable.RoomTempSensorType},
    {Key = "RoomTempRatio", Type = "UInt8", Property = g1.ExtendedPropertyTable.RoomTempSensorRatio},
    {Key = "RoomTempDelta", Type = "Float32", Property = g1.ExtendedPropertyTable.RoomTempDelta, Digits = 1},
    {Key = "RoomTempReadInterval", Type = "UInt8", Property = g1.ExtendedPropertyTable.RoomTempReadInterval},
    {Key = "RoomTempWriteDelta", Type = "Float32", Property = g1.ExtendedPropertyTable.RoomTempWriteDelta, Digits = 1},
    {Key = "RoomTempWriteInterval", Type = "UInt8", Property = g1.ExtendedPropertyTable.RoomTempWriteInterval}
  }
}

local ShowIfHeating =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"}
  },
  Function = function(rtcMode)
    return rtcMode == 0 or rtcMode == 2
  end
}

local ShowIfHeatingAndTypeNot2PointFeedbackControl =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeHeating, Type = "UInt8"}
  },
  Function = function(rtcMode, rtcCtrlModeHeating)
    return (rtcMode == 0 or rtcMode == 2) and rtcCtrlModeHeating ~= 2
  end
}

local ShowIfHeatingAndType2PointFeedbackControl =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeHeating, Type = "UInt8"},
  },
  Function = function(rtcMode, rtcCtrlModeHeating)
    return (rtcMode == 0 or rtcMode == 2) and rtcCtrlModeHeating == 2
  end
}

local ShowIfHeatingAndViaControlParameter =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeHeating, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcHeatingType, Type = "UInt8"},
  },
  Function = function(rtcMode, rtcCtrlModeHeating, rtcHeatingType)
    return (rtcMode == 0 or rtcMode == 2) and (rtcCtrlModeHeating == 0 or rtcCtrlModeHeating == 1) and
    (rtcHeatingType == 5)
  end
}

local ShowIfCooling =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"}
  },
  Function = function(rtcMode)
    return rtcMode == 1 or rtcMode == 2
  end
}

local ShowIfCoolingAndTypeNot2PointFeedbackControl =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeCooling, Type = "UInt8"}
  },
  Function = function(rtcMode, rtcCtrlModeCooling)
    return (rtcMode == 1 or rtcMode == 2) and rtcCtrlModeCooling ~= 2
  end
}

local ShowIfCoolingAndType2PointFeedbackControl =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeCooling, Type = "UInt8"},
  },
  Function = function(rtcMode, rtcCtrlModeCooling)
    return (rtcMode == 1 or rtcMode == 2) and rtcCtrlModeCooling == 2
  end
}

local ShowIfCoolingAndViaControlParameter =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCtrlModeCooling, Type = "UInt8"},
    {Id = g1.ExtendedPropertyTable.RtcCoolingType, Type = "UInt8"},
  },
  Function = function(rtcMode, rtcCtrlModeCooling, rtcCoolingType)
    return (rtcMode == 1 or rtcMode == 2) and (rtcCtrlModeCooling == 0 or rtcCtrlModeCooling == 1) and
    (rtcCoolingType == 3)
  end
}

local ShowIfHeatingAndCooling =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcMode, Type = "UInt8"}
  },
  Function = function(rtcMode)
    return rtcMode == 2
  end
}

local ShowIfPresenceButton =
{
  PropertyIds =
  {
    {Id = g1.ExtendedPropertyTable.RtcCfPresence, Type = "UInt8"}
  },
  Function = function(rtcCfPresence)
    return rtcCfPresence == 1
  end
}

StaticData["RoomTemperatureController"] =
{
  EnabledProperty = g1.ExtendedPropertyTable.RoomTempUse,
  Type = "setting",
  Parameters =
  {
    {Key = "RtcUse", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcUse},
    {Key = "RtcName", Type = "Name", Property = g1.ExtendedPropertyTable.RtcNameOffset},
    {Key = "RtcIcon", Type = "UInt16", Property = g1.ExtendedPropertyTable.RtcIcon},
    {Key = "RtcEtsProgOverwrite", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcEtsProgOverwrite},
    {Key = "RtcMode", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcMode},
    {Key = "RtcTransmitCmdValue", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcTransmitCmdValue, ShowIf = ShowIfHeatingAndCooling},
    {Key = "RtcCtrlModeHeating", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCtrlModeHeating, ShowIf = ShowIfHeating},
    {Key = "RtcCtrlModeCooling", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCtrlModeCooling, ShowIf = ShowIfCooling},
    {Key = "RtcHeatingType", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcHeatingType, ShowIf = ShowIfHeatingAndTypeNot2PointFeedbackControl},
    {Key = "RtcCoolingType", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCoolingType, ShowIf = ShowIfCoolingAndTypeNot2PointFeedbackControl},
    {Key = "RtcHeatLowerLimit", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcHeatLowerLimit, Digits = 1, ShowIf = ShowIfHeatingAndType2PointFeedbackControl},
    {Key = "RtcHeatUpperLimit", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcHeatUpperLimit, Digits = 1, ShowIf = ShowIfHeatingAndType2PointFeedbackControl},
    {Key = "RtcCoolLowerLimit", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcCoolLowerLimit, Digits = 1, ShowIf = ShowIfCoolingAndType2PointFeedbackControl},
    {Key = "RtcCoolUpperLimit", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcCoolUpperLimit, Digits = 1, ShowIf = ShowIfCoolingAndType2PointFeedbackControl},
    {Key = "RtcHeatPropRange", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcHeatPropRange, Digits = 1, ShowIf = ShowIfHeatingAndViaControlParameter},
    {Key = "RtcHeatResetTime", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcHeatResetTime, ShowIf = ShowIfHeatingAndViaControlParameter},
    {Key = "RtcCoolPropRange", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcCoolPropRange, Digits = 1, ShowIf = ShowIfCoolingAndViaControlParameter},
    {Key = "RtcCoolResetTime", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCoolResetTime, ShowIf = ShowIfCoolingAndViaControlParameter},
    {Key = "RtcOpModeViaSwitching", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcOpModeViaSwitching},
    {Key = "RtcOpModeAfterReset", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcOpModeAfterReset},
    {Key = "RtcModeAfterReset", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcModeAfterReset},
    {Key = "RtcProtectionDelay", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcProtectionDelay}
  },
  SubData =
  {
    SetPointValues =
    {
      Type = "setting",
      Parameters =
      {
        {Key = "RtcSpHeatComfort", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpHeatComfort, Digits = 1},
        {Key = "RtcSpHeatStandby", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpHeatStandby, Digits = 1},
        {Key = "RtcSpHeatNight", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpHeatNight, Digits = 1},
        {Key = "RtcSpCoolComfort", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpCoolComfort, Digits = 1},
        {Key = "RtcSpCoolStandby", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpCoolStandby, Digits = 1},
        {Key = "RtcSpCoolNight", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpCoolNight, Digits = 1},
        {Key = "RtcSpAllow", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcSpAllow},
        {Key = "RtcSpMin", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpMin, Digits = 1},
        {Key = "RtcSpMax", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpMax, Digits = 1},
        {Key = "RtcSpStepWidth", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcSpStepWidth},
        {Key = "RtcSpHeatProtect", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpHeatProtect, Digits = 1},
        {Key = "RtcSpFrostProtect", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpFrostProtect, Digits = 1},
        {Key = "RtcSpTransDelay", Type = "Float32", Property = g1.ExtendedPropertyTable.RtcSpTransDelay, Digits = 1},
        {Key = "RtcSpTransCycle", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcSpTransCycle}
      }
    },
    CommandValueAndStatusOutput =
    {
      Type = "setting",
      Parameters =
      {
        {Key = "RtcStatusTransDelta", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusTransDelta},
        {Key = "RtcStatusTransCycle", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusTransCycle},
        {Key = "RtcStatusAutoTrans", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusAutoTrans},
        {Key = "RtcStatusOutputTypeHeat", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusOutputTypeHeat, ShowIf = ShowIfHeating},
        {Key = "RtcStatusCmdValueMinHeat", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueMinHeat, ShowIf = ShowIfHeating},
        {Key = "RtcStatusCmdValueMaxHeat", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueMaxHeat, ShowIf = ShowIfHeating},
        {Key = "RtcStatusHeatingIndication", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcStatusHeatingIndication, ShowIf = ShowIfHeating},
        {Key = "RtcStatusOutputTypeCool", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusOutputTypeCool, ShowIf = ShowIfCooling},
        {Key = "RtcStatusCmdValueMinCool", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueMinCool, ShowIf = ShowIfCooling},
        {Key = "RtcStatusCmdValueMaxCool", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueMaxCool, ShowIf = ShowIfCooling},
        {Key = "RtcStatusCoolingIndication", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcStatusCoolingIndication, ShowIf = ShowIfCooling},
        {Key = "RtcStatusCmdValueLimit", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueLimit},
        {Key = "RtcStatusCmdValueLimitReset", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusCmdValueLimitReset},
        {Key = "RtcStatusStatusType", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusStatusType},
        {Key = "RtcStatusBehavior", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcStatusBehavior}
      }
    },
    ControllerFunctionality =
    {
      Type = "setting",
      Parameters =
      {
        {Key = "RtcCfPresence", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCfPresence},
        {Key = "RtcCfPresenceDuration", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCfPresenceDuration, ShowIf = ShowIfPresenceButton},
        {Key = "RtcCfLocked", Type = "UInt8", Property = g1.ExtendedPropertyTable.RtcCfLocked},
        {Key = "RtcCfSwitchOff", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcCfSwitchOff},
        {Key = "RtcCfValveProtect", Type = "Bool", Property = g1.ExtendedPropertyTable.RtcCfValveProtect}
      }
    }
  }
}

function IsThereUrnsByPropertyIndex(id)
  return (FunctionDefinition[id] and FunctionDefinition[id].VariableUrns and FunctionDefinition[id].VariableUrns.IndexProperty.PropertyId > 0) or false
end

function GetPropertyIndexForUrns(id)
  return (FunctionDefinition[id] and FunctionDefinition[id].VariableUrns and FunctionDefinition[id].VariableUrns.IndexProperty) or 0
end

function GetFunctionUrnByTypeId(id)
  return FunctionDefinition[id] and FunctionDefinition[id].Urns["FunctionUrn"] or "Unused"
end

function GetChannelUrnByTypeId(id)
  return FunctionDefinition[id] and FunctionDefinition[id].Urns["ChannelUrn"] or "Unused"
end

function GetFunctionUrnByTypeIdAndPropertyIndex(id, propertyIndex)
  return (FunctionDefinition[id] and FunctionDefinition[id].VariableUrns and FunctionDefinition[id].VariableUrns.Urns[propertyIndex] and FunctionDefinition[id].VariableUrns.Urns[propertyIndex].FunctionUrn) or "Unused"
end

function GetChannelUrnByTypeIdAndPropertyIndex(id, propertyIndex)
  return (FunctionDefinition[id] and FunctionDefinition[id].VariableUrns and FunctionDefinition[id].VariableUrns.Urns[propertyIndex] and FunctionDefinition[id].VariableUrns.Urns[propertyIndex].ChannelUrn) or "Unused"
end

function GetLuaTemplateIndexByTypeIdAndPropertyIndex(id, propertyIndex)
  return (FunctionDefinition[id] and FunctionDefinition[id].VariableUrns and FunctionDefinition[id].VariableUrns.Urns[propertyIndex] and FunctionDefinition[id].VariableUrns.Urns[propertyIndex].LuaTemplateIndex) or ""
end

function GetParametersFromChannelTypeId(id)
  return FunctionDefinition[id] and FunctionDefinition[id].Parameters or {};
end

function GetPropertyIds()
  PropertyIds = {}
  for key, value in pairs(g1.ExtendedPropertyTable) do
    PropertyIds[key] = value
  end
  return PropertyIds
end

function GetStaticData()
  return StaticData
end