#!/bin/sh

me="[userdata.sh]"

printf "%s Enter.\\n" "${me}"

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

if ! [ -d ${MP_USERDATA} ]
then
    printf "%s Mount point for userdata partition does not exist and can not be created due to read-only filesystem!\\n" "${me}"
    printf "%s Setting bootcounter for booted system to 3.\\n" "${me}"
    printf "3\\n" > ${EXTPARAM}/booted_boot_counter
    ${ENVIRONMENT_SYNC_SCRIPT}
    printf "%s Reboot due to fatal error!\\n" "${me}"
    ${REBOOT}
fi

case "$1" in
  start)
    printf "%s Checking if userdata is already mounted..." "${me}"
    if [ ! -f ${UD_MOUNTED_FILE} ]
    then
      printf "nope.\\n"
      printf "%s Checking userdata fs for errors..." "${me}"
      fsck.${USERDATA_FS_TYPE} -n ${UD_BLOCKDEV} > /dev/null
      # Exit codes > 1 mean errors exist
      if [ "$?" -gt 1 ]
      then
        printf "errors found.\\n"
        # Repairing might take a minute? Disable watchdog to be sure it doesn’t
        # trigger during repair.
        printf "%s Temporarily disabling watchdog...\\n" "${me}"
        KERNEL_VERSION=$(uname -r)
        # Reload watchdog kernel module with nowayout=0
        rmmod imx2_wdt
        insmod /lib/modules/${KERNEL_VERSION}/kernel/drivers/watchdog/imx2_wdt.ko nowayout=0
        printf "%s Attempting file system repair...\\n" "${me}"
        fsck.${USERDATA_FS_TYPE} -y ${UD_BLOCKDEV}
        if [ "$?" -gt 1 ]
        then
          printf "%s Repair failed!\\n" "${me}"
          printf "%s Userdata partition is broken beyond repair. Executing factory reset as last resort!\\n" "${me}"
          printf "enabled\\n" > ${FACTORY_RESET_FILE}
          printf "Rebooting NOW!\\n"
          ${REBOOT}
        else
          printf "%s Repair was successful!\\n" "${me}"
        fi
        printf "%s Re-enabling watchdog...\\n" "${me}"
        rmmod imx2_wdt
        insmod /lib/modules/${KERNEL_VERSION}/kernel/drivers/watchdog/imx2_wdt.ko nowayout=1
      else
        printf "no errors found.\\n"
      fi
      printf "%s Mounting userdata fs..." "${me}"
      $MOUNT -o rw,suid,sync,noatime ${UD_BLOCKDEV} ${MP_USERDATA}
      if [ ! "$(cat /proc/mounts | grep ${MP_USERDATA})" = "" ]
      then
        printf "done.\\n"
        printf "%s Updating mount info...\\n" "${me}"
        touch ${UD_MOUNTED_FILE}
        printf "%s Creating FWU directory...\\n" "${me}"
        mkdir -p ${UD_FWU_DIR}
        # MGR: What is this for?
        logger -t "${me} userdata.initd" -s "Creating directories..."
        mkdir -p ${MP_USERDATA}/knxstack
      else
        printf "failed.\\n"
        printf "Executing factory reset...\\n"
        printf "enabled\\n" > ${FACTORY_RESET_FILE}
        printf "Rebooting NOW!\\n"
        ${REBOOT}
      fi
    else
      printf "yes, skip mounting.\\n"
    fi
    ;;
  stop)
    printf "%s Checking if userdata is mounted..." "${me}"
    if [ -f ${UD_MOUNTED_FILE} ]
    then
      printf "yes.\\n"
      printf "%s Unmounting userdata fs..." "${me}"
      sync
      $UMOUNT ${MP_USERDATA}
      if [ "$(cat /proc/mounts | grep ${MP_USERDATA})" = "" ]
      then
        printf "done.\\n"
      else
        printf "failed.\\n"
        printf "%s Logging open filehandles to %s/ofhandles1.\\n" "${me}" "${MP_USERDATA}"
        /usr/sbin/lsof | /bin/grep '${MP_USERDATA/}' > ${MP_USERDATA}/ofhandles1
        printf "%s Trying again...\\n" "${me}"
        ${GIRA_BIN}/killEmAll-G1
        ${GIRA_BIN}/gapp stop
        ${GIRA_BIN}/gsplash-write "QUIT"
        sleep 1
        sync
        $UMOUNT ${MP_USERDATA}
        if [ "$(cat /proc/mounts | grep ${MP_USERDATA})" = "" ]
        then
          printf "%s Unmounting userdata succeeded after killing all Gira Apps!\\n" "${me}"
        else
          printf "%s Second umount failed after killing all gira apps.\\n" "${me}"
          printf "%s Logging open filehandles to %s/ofhandles2.\\n" "${me}" "${MP_USERDATA}"
          /usr/sbin/lsof | /bin/grep '${MP_USERDATA/}' > ${MP_USERDATA}/ofhandles2
        fi
      fi
    else
      printf "nope. Nothing to do.\\n"
    fi
    ;;
  *)
    printf "Usage: %s (start|stop)\\n" "$0"
    exit 1
esac

printf "%s Exit.\\n" "${me}"

exit 0
