#!/bin/sh

ME="[restoretemplates.sh]"

printf "%s Enter.\\n" "${ME}"

source /opt/gira/share/devicestack/ipmodule-vars

printf "%s Restoring shadow from template ... " "${ME}"
SHADOW_LINK_TARGET=$(readlink /etc/shadow)
mkdir -p "$(dirname ${SHADOW_LINK_TARGET})"
if [ -f "${SHADOW_USER_TEMPLATE}" ]
then
  install -m 600 "${SHADOW_USER_TEMPLATE}" "${SHADOW_LINK_TARGET}"
else
  install -m 600 "${SHADOW_TEMPLATE}" "${SHADOW_LINK_TARGET}"
fi
printf "done.\\n"

if [ -f ${COMMISSIONED_FILE} ]
then
  printf "%s Checking existence of default device user ... " "${ME}"
  if [ -f "${DEFAULT_DEVICE_USER_FILE}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    mkdir -p "${DEVICE_USER_DIR}"

    # If device has initial device password
    if [ -f /opt/extparam/fddp ]
    then
      printf "%s Creating device user with initial device password..." "${ME}"
      install -m 600 /dev/null "${DEFAULT_DEVICE_USER_FILE}"
      printf "pwd:" > "${DEFAULT_DEVICE_USER_FILE}"
      IGPW=$(cat /opt/extparam/fddp)
      if /opt/gira/bin/encode-pw.sh "${IGPW}" >> "${DEFAULT_DEVICE_USER_FILE}"
      then
        printf "done.\\n"
      else
        printf "failed.\\n"
      fi
    else
      printf "%s Creating default device user ... " "${ME}"
      if echo -n "x8q+DQfMqM4+77LfeRWer2C0A5B2kZ4A4kIfAVeJvbw=" > "${DEFAULT_DEVICE_USER_FILE}"
      then
        printf "done.\\n"
      else
        printf "failed.\\n"
      fi
    fi
  fi

  printf "%s Checking appconfig.xml ... " "${ME}"
  if [ -f "${APPCONFIG_FILE}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Copying appconfig.xml ... " "${ME}"
    if cp "${APPCONFIG_FILE_TEMPLATE}" "${APPCONFIG_FILE}"
    then
      printf "done.\\n"
    else
      printf "failed.\\n"
    fi
  fi

  printf "%s Checking devicestackconfig.xml ... " "${ME}"
  if [ -f "${DSCONFIG_FILE}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Copying devicestackconfig.xml ... " "${ME}"
    if cp "${DSCONFIG_FILE_TEMPLATE}" "${DSCONFIG_FILE}"
    then
      printf "done.\\n"
    else
      printf "failed.\\n"
    fi
  fi

  printf "%s Checking custom channel definitions ... " "${ME}"
  if [ -d "${COSTOM_CHANNEL_DIR}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Copying custom channel definitions ... " "${ME}"
    if cp -a "${COSTOM_CHANNEL_DIR_TEMPLATE}" "${COSTOM_CHANNEL_DIR}"
    then
      printf "done.\\n"
    else
      printf "failed.\\n"
    fi
  fi

  printf "%s Checking network.conf ... " "${ME}"
  if [ -d "${NETWORK_CFG_FILE}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Copying network.conf ... " "${ME}"
    if cp -a "${NETWORK_CFG_FILE_TEMPLATE}" "${NETWORK_CFG_FILE}"
    then
      printf "done.\\n"
    else
      printf "failed.\\n"
    fi
  fi

  # FIXME_G1
  # Clarify if this is actually needed and enable or delete below.
  printf "%s Checking custom project definitions ... " "${ME}"
  if [ -d "${CUSTOM_PROJECT_DEFINITION_DIR}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Copying custom project definitions ... " "${ME}"
    if cp -a "${CUSTOM_PROJECT_DEFINITION_DIR_TEMPLATE}" "${CUSTOM_PROJECT_DEFINITION_DIR}"
    then
      printf "done.\\n"
    else
      printf "failed.\\n"
    fi
  fi

  printf "%s Checking connman configuration directory ... " "${ME}"
  if [ -d "${CONNMAN_CONFIG_DIR}" ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Creating connman configuration directory ... " "${ME}"
    if mkdir -p "${CONNMAN_CONFIG_DIR}"
    then
      printf " Done.\\n"
      printf "%s Copying connman templates ... " "${ME}"
      cp "${CONNMAN_TEMPLATE_DIR}/settings" "${CONNMAN_CONFIG_DIR}"
      printf "Done.\\n"
    else
      printf "Failed!\\n"
    fi
  fi
  
  printf "%s Checking directory for random seed ... " "${ME}"
  if [ -d ${MP_USERDATA}/urandom ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Creating directory for random seed ... " "${ME}"
    if mkdir ${MP_USERDATA}/urandom
    then
      printf "Done\\n"
    else
      printf "Failed!\\n"
    fi
  fi
  
  printf "%s Checking link to localtime ... " "${ME}"
  if [ -h ${DS_ETC_USERDATA}/timezone ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Creating link to timezone Europe/Berlin ... " "${ME}"
    if ln -sf /usr/share/zoneinfo/Europe/Berlin ${DS_ETC_USERDATA}/timezone
    then
      printf "Done\\n"
    else
      printf "Failed!\\n"
    fi
  fi
  
  echo -n "${ME} Checking link for wpa-supplicant service ... "
  if [ -h ${WPA_SERVICE_CONFIG_DIR}/fi.w1.wpa_supplicant1.service ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Creating link to wpa-supplicant service template ... " "${ME}"
    mkdir -p ${WPA_SERVICE_CONFIG_DIR}
    if ln -sf ${WPA_TEMPLATE_DIR}/fi.w1.wpa_supplicant1.service ${WPA_SERVICE_CONFIG_DIR}/fi.w1.wpa_supplicant1.service
    then
      printf "Done\\n"
    else
      printf "Failed!\\n"
    fi
  fi

  printf "%s Checking ntp drift file ... " "${ME}"
  if [ -f ${MP_USERDATA}/ntp.drift ]
  then
    printf "found.\\n"
  else
    printf "not found.\\n"
    printf "%s Restoring ntp drift file from template ... " "${ME}"
    if cp ${DS_TEMPLATE_DIR}/ntp.drift.template ${MP_USERDATA}/ntp.drift
    then
      printf "Done\\n"
    else
      printf "Failed!\\n"
    fi
  fi
fi

printf "%s Exit.\\n" "${ME}"

exit 0
